/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl;

import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.DocumentContent;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.exceptions.NoTxFoundForDocumentException;
import de.adorsys.docusafe.transactional.exceptions.TxAlreadyClosedException;
import de.adorsys.docusafe.transactional.exceptions.TxNotFoundException;
import de.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import de.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import de.adorsys.docusafe.transactional.impl.TxIDHashMap;
import de.adorsys.docusafe.transactional.impl.TxIDLog;
import de.adorsys.docusafe.transactional.impl.helper.BucketContentFromHashMapHelper;
import de.adorsys.docusafe.transactional.impl.helper.Class2JsonHelper;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import de.adorsys.docusafe.transactional.types.TxID;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxIDHashMapWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxIDHashMapWrapper.class);
    private static final DocumentFQN filenamebase = new DocumentFQN("TransactionalHashMap.txt");
    private TxID mergedTxID = null;
    private TxID lastCommitedTxID;
    private TxID currentTxID;
    private Date beginTx;
    private Date endTx;
    private TxIDHashMap map = new TxIDHashMap();

    private TxIDHashMapWrapper(TxID lastCommitedTxID, TxID currentTx, Date beginTxDate) {
        this.lastCommitedTxID = lastCommitedTxID;
        this.currentTxID = currentTx;
        this.beginTx = beginTxDate;
    }

    public TxIDHashMapWrapper clone() {
        TxIDHashMapWrapper newTxIDHashMapWrapper = new TxIDHashMapWrapper(this.lastCommitedTxID, this.currentTxID, this.beginTx);
        newTxIDHashMapWrapper.map.putAll(this.map);
        return newTxIDHashMapWrapper;
    }

    public static TxIDHashMapWrapper fromPreviousFileOrNew(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, TxID currentTxID, Date beginTxDate) {
        TxID lastKnownCommitedTxID = TxIDLog.findLastCommitedTxID(documentSafeService, userIDAuth);
        if (lastKnownCommitedTxID == null) {
            return new TxIDHashMapWrapper(lastKnownCommitedTxID, currentTxID, beginTxDate);
        }
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastKnownCommitedTxID);
        TxIDHashMapWrapper map = TxIDHashMapWrapper.readHashMapOfTx(documentSafeService, userIDAuth, lastKnownCommitedTxID);
        map.lastCommitedTxID = map.currentTxID;
        map.currentTxID = currentTxID;
        map.beginTx = beginTxDate;
        map.endTx = null;
        return map;
    }

    public static TxIDHashMapWrapper readHashMapOfTx(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, TxID lastCommitedTxID) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastCommitedTxID);
        if (!documentSafeService.documentExists(userIDAuth, file)) {
            throw new TxNotFoundException(file, lastCommitedTxID);
        }
        DSDocument dsDocument = documentSafeService.readDocument(userIDAuth, file);
        return new Class2JsonHelper().txidHashMapFromContent(dsDocument.getDocumentContent());
    }

    public static void deleteHashMapOfTx(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, TxID lastCommitedTxID) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastCommitedTxID);
        if (!documentSafeService.documentExists(userIDAuth, file)) {
            throw new TxNotFoundException(file, lastCommitedTxID);
        }
        LOGGER.debug("delete transactional HashMap file" + file);
        documentSafeService.deleteDocument(userIDAuth, file);
    }

    public void saveOnce(DocumentSafeService documentSafeService, UserIDAuth userIDAuth) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, this.currentTxID);
        LOGGER.debug("save " + file.getValue());
        DocumentContent documentContent = new Class2JsonHelper().txidHashMapToContent(this);
        DSDocument dsDocument = new DSDocument(file, documentContent);
        documentSafeService.storeDocument(userIDAuth, dsDocument);
    }

    public void storeDocument(DocumentFQN documentFQN) {
        this.map.put(documentFQN, this.currentTxID);
    }

    public TxID getTxIDOfDocument(DocumentFQN documentFQN) {
        TxID txID = (TxID)((Object)this.map.get(documentFQN));
        if (txID == null) {
            throw new NoTxFoundForDocumentException(documentFQN);
        }
        return txID;
    }

    public void deleteDocument(DocumentFQN documentFQN) {
        this.map.remove(documentFQN);
    }

    public boolean documentExists(DocumentFQN documentFQN) {
        return this.map.containsKey(documentFQN);
    }

    public void deleteFolder(DocumentDirectoryFQN documentDirectoryFQN) {
        ArrayList entriesToRemove = new ArrayList();
        this.map.keySet().forEach(documentFQN -> {
            if (documentFQN.getValue().startsWith(documentDirectoryFQN.getValue())) {
                entriesToRemove.add(documentFQN);
            }
        });
        entriesToRemove.forEach(documentFQN -> this.deleteDocument((DocumentFQN)documentFQN));
    }

    public void setEndTransactionDate(Date endTransactionDate) {
        this.endTx = endTransactionDate;
    }

    public void transactionIsOver(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, CurrentTransactionData currentTransactionData) {
        TxIDLog.saveJustFinishedTx(documentSafeService, userIDAuth, currentTransactionData);
    }

    public TxBucketContentFQN list(DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return BucketContentFromHashMapHelper.list(this.map, documentDirectoryFQN, recursiveFlag);
    }

    public void checkTxStillOpen() {
        if (this.endTx != null) {
            throw new TxAlreadyClosedException(this.currentTxID);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("TxIDHashMapWrapper {");
        sb.append("\n");
        sb.append("  merged tx        : " + (Object)((Object)this.mergedTxID));
        sb.append("\n");
        sb.append("  last commited tx : " + (Object)((Object)this.lastCommitedTxID));
        sb.append("\n");
        sb.append("  current tx       : " + (Object)((Object)this.currentTxID));
        sb.append("\n");
        sb.append("  begin - end      : " + this.getString(this.beginTx) + " - " + this.getString(this.endTx));
        sb.append("\n");
        sb.append(TxIDHashMapWrapper.getString(this.map));
        sb.append("}\n");
        return sb.toString();
    }

    private String getString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH.mm.ss,SSS");
        return sdf.format(date);
    }

    public static String getString(TxIDHashMap map) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        ArrayList list = new ArrayList();
        list.addAll(map.keySet());
        Collections.sort(list, new DocumentFQNComparator());
        for (DocumentFQN documentFQN : list) {
            sb.append("  " + documentFQN.getValue() + "." + ((TxID)((Object)map.get(documentFQN))).getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static TxIDHashMapWrapperBuilder builder() {
        return new TxIDHashMapWrapperBuilder();
    }

    public TxIDHashMapWrapperBuilder toBuilder() {
        return new TxIDHashMapWrapperBuilder().mergedTxID(this.mergedTxID).lastCommitedTxID(this.lastCommitedTxID).currentTxID(this.currentTxID).beginTx(this.beginTx).endTx(this.endTx).map(this.map);
    }

    public TxID getMergedTxID() {
        return this.mergedTxID;
    }

    public TxID getLastCommitedTxID() {
        return this.lastCommitedTxID;
    }

    public TxID getCurrentTxID() {
        return this.currentTxID;
    }

    public Date getBeginTx() {
        return this.beginTx;
    }

    public Date getEndTx() {
        return this.endTx;
    }

    public TxIDHashMap getMap() {
        return this.map;
    }

    public void setMergedTxID(TxID mergedTxID) {
        this.mergedTxID = mergedTxID;
    }

    public void setLastCommitedTxID(TxID lastCommitedTxID) {
        this.lastCommitedTxID = lastCommitedTxID;
    }

    public void setCurrentTxID(TxID currentTxID) {
        this.currentTxID = currentTxID;
    }

    public void setBeginTx(Date beginTx) {
        this.beginTx = beginTx;
    }

    public void setEndTx(Date endTx) {
        this.endTx = endTx;
    }

    public void setMap(TxIDHashMap map) {
        this.map = map;
    }

    public TxIDHashMapWrapper() {
    }

    @ConstructorProperties(value={"mergedTxID", "lastCommitedTxID", "currentTxID", "beginTx", "endTx", "map"})
    public TxIDHashMapWrapper(TxID mergedTxID, TxID lastCommitedTxID, TxID currentTxID, Date beginTx, Date endTx, TxIDHashMap map) {
        this.mergedTxID = mergedTxID;
        this.lastCommitedTxID = lastCommitedTxID;
        this.currentTxID = currentTxID;
        this.beginTx = beginTx;
        this.endTx = endTx;
        this.map = map;
    }

    public static class TxIDHashMapWrapperBuilder {
        private TxID mergedTxID;
        private TxID lastCommitedTxID;
        private TxID currentTxID;
        private Date beginTx;
        private Date endTx;
        private TxIDHashMap map;

        TxIDHashMapWrapperBuilder() {
        }

        public TxIDHashMapWrapperBuilder mergedTxID(TxID mergedTxID) {
            this.mergedTxID = mergedTxID;
            return this;
        }

        public TxIDHashMapWrapperBuilder lastCommitedTxID(TxID lastCommitedTxID) {
            this.lastCommitedTxID = lastCommitedTxID;
            return this;
        }

        public TxIDHashMapWrapperBuilder currentTxID(TxID currentTxID) {
            this.currentTxID = currentTxID;
            return this;
        }

        public TxIDHashMapWrapperBuilder beginTx(Date beginTx) {
            this.beginTx = beginTx;
            return this;
        }

        public TxIDHashMapWrapperBuilder endTx(Date endTx) {
            this.endTx = endTx;
            return this;
        }

        public TxIDHashMapWrapperBuilder map(TxIDHashMap map) {
            this.map = map;
            return this;
        }

        public TxIDHashMapWrapper build() {
            return new TxIDHashMapWrapper(this.mergedTxID, this.lastCommitedTxID, this.currentTxID, this.beginTx, this.endTx, this.map);
        }

        public String toString() {
            return "TxIDHashMapWrapper.TxIDHashMapWrapperBuilder(mergedTxID=" + (Object)((Object)this.mergedTxID) + ", lastCommitedTxID=" + (Object)((Object)this.lastCommitedTxID) + ", currentTxID=" + (Object)((Object)this.currentTxID) + ", beginTx=" + this.beginTx + ", endTx=" + this.endTx + ", map=" + this.map + ")";
        }
    }

    static class DocumentFQNComparator
    implements Comparator<DocumentFQN> {
        DocumentFQNComparator() {
        }

        @Override
        public int compare(DocumentFQN o1, DocumentFQN o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

