/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl;

import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.types.DFSCredentials;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.UserID;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.NonTransactionalDocumentSafeService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTransactionalDocumentSafeServiceImpl
implements NonTransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonTransactionalDocumentSafeServiceImpl.class);
    protected DocumentSafeService documentSafeService;

    public NonTransactionalDocumentSafeServiceImpl(DocumentSafeService documentSafeService) {
        LOGGER.debug("new Instance of TransactionalDocumentSafeServiceImpl");
        this.documentSafeService = documentSafeService;
    }

    @Override
    public void createUser(UserIDAuth userIDAuth) {
        this.documentSafeService.createUser(userIDAuth);
    }

    @Override
    public void destroyUser(UserIDAuth userIDAuth) {
        this.documentSafeService.destroyUser(userIDAuth);
    }

    @Override
    public boolean userExists(UserID userID) {
        return this.documentSafeService.userExists(userID);
    }

    @Override
    public void registerDFSCredentials(UserIDAuth userIDAuth, DFSCredentials dfsCredentials) {
        this.documentSafeService.registerDFSCredentials(userIDAuth, dfsCredentials);
    }

    @Override
    public List<DocumentFQN> nonTxListInbox(UserIDAuth userIDAuth) {
        return this.documentSafeService.listInbox(userIDAuth);
    }
}

