/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl;

import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.transactional.impl.TxIDHashMap;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTransactionData {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentTransactionData.class);
    private TxID currentTxID = null;
    private TxIDHashMapWrapper currentTxHashMap = null;
    private TxIDHashMapWrapper initialTxHashMap = null;
    private TxIDHashMap documentsReadInThisTx = new TxIDHashMap();
    private Set<DocumentFQN> nonTxInboxDocumentsToBeDeletedAfterCommit = new HashSet<DocumentFQN>();

    public CurrentTransactionData(TxID currentTxID, TxIDHashMapWrapper currentTxHashMap) {
        this.currentTxID = currentTxID;
        this.currentTxHashMap = currentTxHashMap;
        this.initialTxHashMap = currentTxHashMap.clone();
    }

    public TxID getCurrentTxID() {
        return this.currentTxID;
    }

    public TxIDHashMapWrapper getCurrentTxHashMap() {
        return this.currentTxHashMap;
    }

    public TxIDHashMapWrapper getInitialTxHashMap() {
        return this.initialTxHashMap;
    }

    public TxIDHashMap getDocumentsReadInThisTx() {
        return this.documentsReadInThisTx;
    }

    public boolean anyDifferenceToInitalState() {
        HashSet currentFQNs = new HashSet(this.currentTxHashMap.getMap().keySet());
        HashSet initialFQNs = new HashSet(this.initialTxHashMap.getMap().keySet());
        if (currentFQNs.size() > initialFQNs.size()) {
            currentFQNs.removeAll(initialFQNs);
            currentFQNs.forEach(fqn -> LOGGER.debug(" new file has been created: " + fqn));
            return true;
        }
        if (currentFQNs.size() < initialFQNs.size()) {
            initialFQNs.removeAll(currentFQNs);
            initialFQNs.forEach(fqn -> LOGGER.debug(" old file has been removed: " + fqn));
            return true;
        }
        for (DocumentFQN fqn2 : currentFQNs) {
            TxID initialTxID;
            if (!initialFQNs.contains(fqn2)) {
                LOGGER.debug(" old file has been removed: " + fqn2);
                return true;
            }
            TxID currentTxID = (TxID)((Object)this.currentTxHashMap.getMap().get(fqn2));
            if (currentTxID.equals((Object)(initialTxID = (TxID)((Object)this.initialTxHashMap.getMap().get(fqn2))))) continue;
            LOGGER.debug(" old file has changed:" + fqn2);
            return true;
        }
        LOGGER.debug(" nothing has changed");
        return false;
    }

    public void addNonTxInboxFileToBeDeletedAfterCommit(DocumentFQN nonTxFQN) {
        this.nonTxInboxDocumentsToBeDeletedAfterCommit.add(nonTxFQN);
    }

    public Set<DocumentFQN> getNonTxInboxDocumentsToBeDeletedAfterCommit() {
        return this.nonTxInboxDocumentsToBeDeletedAfterCommit;
    }
}

