/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.common.utils.HexUtil;
import de.adorsys.docusafe.service.api.types.UserID;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedWithStringOfClassTxIDLogTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedWithStringOfClassTxIDLogTest.class);

    @Test
    public void testMethodsaveJustFinishedTxForSameString() {
        this.testMethodsaveJustFinishedTx(100, false);
    }

    @Test
    public void testMethodsaveJustFinishedTxForDifferentString() {
        this.testMethodsaveJustFinishedTx(100, true);
    }

    public void lasttest() {
        int counter = 0;
        while (true) {
            LOGGER.info("COUNTER IS NOW " + counter++);
            this.testMethodsaveJustFinishedTx(100, false);
            this.testMethodsaveJustFinishedTx(100, true);
        }
    }

    public void testMethodsaveJustFinishedTx(int WAIT, boolean differ) {
        try {
            int MAX_DELTA = 20;
            Semaphore semaphore = new Semaphore(2);
            CountDownLatch countDownLatch = new CountDownLatch(2);
            semaphore.acquire(2);
            ARunnable runnable1 = new ARunnable(semaphore, countDownLatch, WAIT, false);
            ARunnable runnable2 = new ARunnable(semaphore, countDownLatch, WAIT, differ);
            Thread[] instances = new Thread[]{new Thread(runnable1), new Thread(runnable2)};
            instances[0].start();
            instances[1].start();
            LOGGER.info("prepare for start");
            Thread.currentThread();
            Thread.sleep(2000L);
            LOGGER.info("GO");
            semaphore.release(2);
            LOGGER.info("wait for two instances to finsih");
            countDownLatch.await();
            long fast = Math.min(runnable1.durationInMillis, runnable2.durationInMillis);
            long slow = Math.max(runnable1.durationInMillis, runnable2.durationInMillis);
            LOGGER.info("fast thread took " + fast);
            LOGGER.info("slow thread took " + slow);
            if (differ) {
                LOGGER.info("assume both threads did not run longer than " + (WAIT + MAX_DELTA));
                Assert.assertTrue((fast < (long)(WAIT + MAX_DELTA) ? 1 : 0) != 0);
                Assert.assertTrue((slow < (long)(WAIT + MAX_DELTA) ? 1 : 0) != 0);
            } else {
                long starttimeOfFastThread = fast == runnable1.durationInMillis ? runnable1.starttime : runnable2.starttime;
                long starttimeOfSlowThread = fast == runnable1.durationInMillis ? runnable2.starttime : runnable1.starttime;
                long delay = starttimeOfSlowThread - starttimeOfFastThread;
                LOGGER.info("starttime of fast thread was " + this.getString(new Date(starttimeOfFastThread)));
                LOGGER.info("starttime of slow thread was " + this.getString(new Date(starttimeOfSlowThread)));
                LOGGER.info("delay is " + delay);
                LOGGER.info("assume fast threads did not run longer than " + (WAIT + MAX_DELTA));
                Assert.assertTrue((fast < (long)(WAIT + MAX_DELTA) ? 1 : 0) != 0);
                LOGGER.info("assume slow threads did not run longer than " + ((long)(WAIT + MAX_DELTA) + ((long)WAIT - delay)));
                Assert.assertTrue((slow < (long)(WAIT + MAX_DELTA) + ((long)WAIT - delay) ? 1 : 0) != 0);
                LOGGER.info("assume slow threads did run longer or equal than " + ((long)WAIT + ((long)WAIT - delay)));
                Assert.assertTrue((slow >= (long)WAIT + ((long)WAIT - delay) ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private String getString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH.mm.ss,SSS");
        return sdf.format(date);
    }

    private static class Blocker {
        private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedWithStringOfClassTxIDLogTest.class);

        private Blocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blockForString(UserID s, int timeToBlock) {
            String string = s.getValue().intern();
            synchronized (string) {
                LOGGER.info("start method for " + s);
                try {
                    Thread.currentThread();
                    Thread.sleep(timeToBlock);
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
                LOGGER.info("finish method for " + s);
            }
        }
    }

    public static class ARunnable
    implements Runnable {
        private int timeToBlock;
        private UserID key;
        private Semaphore semaphore;
        private CountDownLatch countDownLatch;
        public long durationInMillis = -1L;
        public long starttime = -1L;
        public long endtime = -1L;
        private Blocker blocker = new Blocker();

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, int timeToBlock, boolean differ) {
            this.timeToBlock = timeToBlock;
            this.semaphore = sem;
            this.countDownLatch = countDownLatch;
            this.key = new UserID(new String(HexUtil.convertHexStringToBytes((String)HexUtil.convertBytesToHexString((byte[])(differ ? "bifi" : "affe").getBytes()))));
        }

        @Override
        public void run() {
            try {
                this.semaphore.acquire();
                LOGGER.info("start for key " + this.key);
                this.starttime = new Date().getTime();
                this.blocker.blockForString(this.key, this.timeToBlock);
                this.endtime = new Date().getTime();
                this.durationInMillis = this.endtime - this.starttime;
                LOGGER.info("finsih for key " + this.key);
                this.semaphore.release();
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

