/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import de.adorsys.docusafe.transactional.RequestMemoryContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRequestMemoryContextImpl
implements RequestMemoryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRequestMemoryContextImpl.class);
    private Map<String, TransactionalContext> pseudoUserMap = new HashMap<String, TransactionalContext>();
    TransactionalContext current = null;

    public void put(Object key, Object value) {
        this.current.put(key, value);
    }

    public Object get(Object key) {
        return this.current.get(key);
    }

    public SimpleRequestMemoryContextImpl() {
        this.switchToUser(1);
    }

    public void switchToUser(int i) {
        String key = "" + i;
        if (!this.pseudoUserMap.containsKey(key)) {
            LOGGER.debug("User is new :" + key);
            this.pseudoUserMap.put(key, new TransactionalContext(key));
        } else {
            LOGGER.debug("User is known :" + key);
        }
        this.current = this.pseudoUserMap.get(key);
        LOGGER.debug("current tx context " + this.current);
    }

    public static class TransactionalContext
    extends HashMap<Object, Object> {
        private static String KEY = "KEY";

        public TransactionalContext(String key) {
            this.put(KEY, key);
        }

        @Override
        public String toString() {
            return "TransactionalContext{" + this.get(KEY) + "}";
        }
    }
}

