/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.filesystem.FilesystemConnectionPropertiesImpl;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3RootBucketName;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.impl.amazons3.AmazonS3ConnectionProperitesImpl;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import de.adorsys.docusafe.business.types.DFSCredentials;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.business.types.MoveType;
import de.adorsys.docusafe.service.api.types.DocumentContent;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import de.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import de.adorsys.docusafe.transactional.exceptions.TxRacingConditionException;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import de.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalDocumentSafeServiceTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceTest.class);

    @Test
    public void sendDocumentFromSystemUserToPeter() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        this.transactionalDocumentSafeService.createUser(this.systemUserIDAuth);
        DocumentFQN systemUserSourceDocFileName = new DocumentFQN("myfolder/firstFileOfSystemUser.txt");
        DocumentFQN petersInboxFileName = new DocumentFQN("peter/inboxfilename.txt");
        DocumentFQN petersTxFileName = new DocumentFQN("peterInternal/internalFilename.txt");
        LOGGER.debug("System user beginnt Transaction");
        this.transactionalDocumentSafeService.beginTransaction(this.systemUserIDAuth);
        LOGGER.debug("System user erstellt document");
        DocumentContent documentContent = new DocumentContent("content for in put box".getBytes());
        this.transactionalDocumentSafeService.txStoreDocument(this.systemUserIDAuth, new DSDocument(systemUserSourceDocFileName, documentContent));
        LOGGER.debug("System sucht Document");
        TxBucketContentFQN txBucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.systemUserIDAuth, systemUserSourceDocFileName.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)txBucketContentFQN.getFiles().size());
        LOGGER.debug("Peter beginnt Transaction");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("Peter hat noch nix in der Inbox");
        List list = this.transactionalDocumentSafeService.nonTxListInbox(this.userIDAuth);
        Assert.assertEquals((long)0L, (long)list.size());
        LOGGER.debug("systemUser sendet Document an peter");
        this.transactionalDocumentSafeService.txMoveDocumentToInboxOfUser(this.systemUserIDAuth, this.userIDAuth.getUserID(), systemUserSourceDocFileName, petersInboxFileName, MoveType.MOVE);
        LOGGER.debug("peter l\u00e4dt das document");
        this.transactionalDocumentSafeService.txMoveDocumentFromInbox(this.userIDAuth, petersInboxFileName, petersTxFileName);
        LOGGER.debug("peter liest das document aus seinem tx space");
        this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, petersTxFileName);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.endTransaction(this.systemUserIDAuth);
    }

    @Test
    public void getCorrectVersionNumber() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        TxDocumentFQNVersion version = null;
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN));
        Assert.assertTrue((CatchException.caughtException() != null ? 1 : 0) != 0);
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        version = this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        Assert.assertEquals((Object)version, (Object)this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, documentFQN);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN));
        Assert.assertTrue((CatchException.caughtException() != null ? 1 : 0) != 0);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }

    @Test
    public void testOverwrite() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        TxBucketContentFQN bucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN.getFiles().get(0));
        DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)documentFQN, (Object)dsDocument.getDocumentFQN());
        Assert.assertArrayEquals((byte[])document.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        DSDocument newDocument = null;
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        TxBucketContentFQN bucketContentFQN2 = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN2.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN2.getFiles().get(0));
        DSDocument dsDocument2 = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        newDocument = new DSDocument(documentFQN, new DocumentContent("new content".getBytes()));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, newDocument);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])newDocument.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }

    @Test
    public void innerTxNotImplementedYet() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth));
        Assert.assertTrue((CatchException.caughtException() != null ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAndChange() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent1 = new DocumentContent("very first".getBytes());
        DocumentContent documentContent2 = new DocumentContent("second".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent1);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("FIRST TXID ");
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(2);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("SECOND TXID ");
        DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        DSDocument document2 = new DSDocument(documentFQN, documentContent2);
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document2);
        this.requestMemoryContext.switchToUser(3);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("THIRD TXID ");
        this.requestMemoryContext.switchToUser(2);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(4);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("FOURTH TXID ");
        this.requestMemoryContext.switchToUser(3);
        dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        this.requestMemoryContext.switchToUser(4);
        dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent2.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        this.requestMemoryContext.switchToUser(4);
        TxBucketContentFQN list = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        list.getFiles().forEach(file -> LOGGER.debug("file:" + file));
        Assert.assertEquals((long)1L, (long)list.getFiles().size());
    }

    @Test
    public void testDelete() {
        DocumentFQN docFQN;
        int i;
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        int N = 5;
        N = 2;
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            DocumentContent docContent = new DocumentContent(("Content_" + i).getBytes());
            DSDocument doc = new DSDocument(docFQN, docContent);
            this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, doc);
        }
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(2);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(3);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(4);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(2);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
            this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, docFQN);
            Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            this.requestMemoryContext.switchToUser(3);
            Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
            this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.requestMemoryContext.switchToUser(3);
        this.transactionalDocumentSafeService.txDeleteFolder(this.userIDAuth, new DocumentDirectoryFQN("folder1"));
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            this.requestMemoryContext.switchToUser(3);
            Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
            this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.requestMemoryContext.switchToUser(3);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.endTransaction(this.userIDAuth));
        Assert.assertTrue((boolean)(CatchException.caughtException() instanceof TxRacingConditionException));
        this.requestMemoryContext.switchToUser(4);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }

    @Test(expected=TxNotActiveException.class)
    public void testEndTxTwice() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }

    @Test
    public void twoCommitsInARow() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("FIRST TXID ");
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("SECOND TXID ");
        DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN));
        Assert.assertTrue((boolean)(CatchException.caughtException() instanceof TxNotActiveException));
    }

    @Test
    public void registerNewDFS() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        TxDocumentFQNVersion version = null;
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        CatchException.catchException(() -> this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN));
        Assert.assertTrue((CatchException.caughtException() != null ? 1 : 0) != 0);
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        version = this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        ConnectionProperties props = DFSConnectionFactory.get().getConnectionProperties();
        DFSCredentials dfsCredentials = new DFSCredentials(this.changeRootDirectory(props, "another-dfs-for-user"));
        this.transactionalDocumentSafeService.registerDFSCredentials(this.userIDAuth, dfsCredentials);
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        Assert.assertEquals((Object)version, (Object)this.transactionalDocumentSafeService.getVersion(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }

    private ConnectionProperties changeRootDirectory(ConnectionProperties props, String deeper) {
        if (props instanceof FilesystemConnectionPropertiesImpl) {
            FilesystemConnectionPropertiesImpl p = (FilesystemConnectionPropertiesImpl)props;
            String root = p.getFilesystemRootBucketName().getValue();
            root = root + "/" + deeper;
            p.setFilesystemRootBucketName(new FilesystemRootBucketName(root));
            return p;
        }
        if (props instanceof AmazonS3ConnectionProperitesImpl) {
            AmazonS3ConnectionProperitesImpl p = (AmazonS3ConnectionProperitesImpl)props;
            String root = p.getAmazonS3RootBucketName().getValue();
            root = root + "/" + deeper;
            p.setAmazonS3RootBucketName(new AmazonS3RootBucketName(root));
            return p;
        }
        throw new BaseException("unknown instance of properties:" + props);
    }
}

