/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl.helper;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.transactional.exceptions.TxBaseException;
import de.adorsys.docusafe.transactional.exceptions.TxParallelCommittingException;
import de.adorsys.docusafe.transactional.impl.TxIDHashMap;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTransactionLogic {
    private static final Logger log = LoggerFactory.getLogger(ParallelTransactionLogic.class);

    public static TxIDHashMapWrapper join(TxIDHashMapWrapper stateLastCommittedTx, TxIDHashMapWrapper stateAtBeginOfCurrentTx, TxIDHashMapWrapper stateAtEndOfCurrentTx, TxIDHashMap documentsTouchedInTx) {
        TxID lastCommitedTxID = stateLastCommittedTx.getCurrentTxID();
        if (lastCommitedTxID != null && lastCommitedTxID.equals((Object)stateAtBeginOfCurrentTx.getLastCommitedTxID())) {
            throw new TxBaseException("Nothing to merge. No parallel transactions committed.");
        }
        Set docsTouched = stateAtEndOfCurrentTx.getMap().entrySet().stream().filter(e -> ((TxID)((Object)((Object)e.getValue()))).equals((Object)stateAtEndOfCurrentTx.getCurrentTxID())).map(Map.Entry::getKey).collect(Collectors.toSet());
        docsTouched.addAll(documentsTouchedInTx.keySet());
        MapDifference currentTxDiff = Maps.difference((Map)stateAtBeginOfCurrentTx.getMap(), (Map)stateAtEndOfCurrentTx.getMap());
        docsTouched.addAll(currentTxDiff.entriesOnlyOnLeft().keySet());
        MapDifference parallelTxDiff = Maps.difference((Map)stateLastCommittedTx.getMap(), (Map)stateAtBeginOfCurrentTx.getMap());
        ArrayList docsTouchedInParallel = new ArrayList(parallelTxDiff.entriesDiffering().keySet());
        docsTouchedInParallel.addAll(parallelTxDiff.entriesOnlyOnLeft().keySet());
        docsTouchedInParallel.addAll(parallelTxDiff.entriesOnlyOnRight().keySet());
        for (DocumentFQN d : docsTouched) {
            if (!docsTouchedInParallel.contains(d)) continue;
            TxParallelCommittingException txParallelCommittingException = new TxParallelCommittingException(stateAtEndOfCurrentTx.getCurrentTxID(), stateLastCommittedTx.getCurrentTxID(), d);
            log.error("join begin of tx        : " + stateAtBeginOfCurrentTx.toString());
            log.error("join end of tx          : " + stateAtEndOfCurrentTx.toString());
            log.error("join last committed tx  : " + stateLastCommittedTx.toString());
            log.error("join read in current tx : " + TxIDHashMapWrapper.getString(documentsTouchedInTx));
            log.error("join result of tx       : " + txParallelCommittingException.getMessage());
            throw txParallelCommittingException;
        }
        TxIDHashMap joinedMap = new TxIDHashMap();
        joinedMap.putAll(stateAtEndOfCurrentTx.getMap());
        joinedMap.putAll(stateLastCommittedTx.getMap());
        TxIDHashMapWrapper build = TxIDHashMapWrapper.builder().lastCommitedTxID(stateAtEndOfCurrentTx.getCurrentTxID()).currentTxID(new TxID()).beginTx(new Date()).endTx(new Date()).map(joinedMap).mergedTxID(stateLastCommittedTx.getCurrentTxID()).build();
        if (log.isDebugEnabled()) {
            log.debug("join begin of tx        : " + stateAtBeginOfCurrentTx.toString());
            log.debug("join end of tx          : " + stateAtEndOfCurrentTx.toString());
            log.debug("join last committed tx  : " + stateLastCommittedTx.toString());
            log.debug("join read in current tx : " + TxIDHashMapWrapper.getString(documentsTouchedInTx));
            log.debug("join result of tx       : " + build.toString());
        }
        return build;
    }
}

