/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.DocumentContent;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.ParallelCommitTxTest;
import de.adorsys.docusafe.transactional.RequestMemoryContext;
import de.adorsys.docusafe.transactional.SimpleRequestMemoryContextImpl;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import de.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import de.adorsys.docusafe.transactional.impl.helper.CleanupLogic;
import de.adorsys.docusafe.transactional.impl.helper.TransactionInformationList;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CleanupLogic.class})
@PowerMockIgnore(value={"javax.*"})
public class TxHistoryCleanupTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(TxHistoryCleanupTest.class);

    @Test
    public void createFilesAndDeleteSomeRandomFilesInServeralTransactions() {
        int currentNumberOfFiles;
        TxBucketContentFQN bucketContentFQN;
        int j;
        int i;
        CleanupLogic cl = (CleanupLogic)Mockito.spy((Object)new CleanupLogic());
        PowerMockito.whenNew(CleanupLogic.class).withNoArguments().thenAnswer(in -> {
            log.info("powermodckit works fine for CleanupLogic");
            return cl;
        });
        StopWatch st = new StopWatch();
        st.start();
        HashMap<DocumentFQN, DocumentContent> memoryMap = new HashMap<DocumentFQN, DocumentContent>();
        int numberOfTransactinos = 3;
        int numberOfFilesToDeletePerTx = 1;
        int numberOfFilesToCreatePerTx = 3;
        int numberOfFilesToOverwritePerTx = 2;
        int expectedNumberOfFilesAfterIteration = numberOfFilesToCreatePerTx * numberOfTransactinos - numberOfTransactinos * numberOfFilesToDeletePerTx;
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentDirectoryFQN documentDirectoryFQN = new DocumentDirectoryFQN("folder");
        log.info("numberOfTransactions:                " + numberOfTransactinos);
        log.info("numberOfFilesToDeletePerTx:          " + numberOfFilesToDeletePerTx);
        log.info("numberOfFilesToCreatePerTx:          " + numberOfFilesToCreatePerTx);
        log.info("numberOfFilesToOverwritePerTx:       " + numberOfFilesToOverwritePerTx);
        log.info("expectedNumberOfFilesAfterIteration: " + expectedNumberOfFilesAfterIteration);
        int staticCounter = 0;
        for (i = 0; i < numberOfTransactinos; ++i) {
            log.debug("create LIST OF FILES IN DOCUMENTSAFE: " + this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).size());
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            log.debug("create LIST OF FILES IN TX: " + this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).getFilesWithVersion().size());
            for (j = 0; j < numberOfFilesToCreatePerTx; ++j) {
                DSDocument document = new DSDocument(documentDirectoryFQN.addName("file_" + staticCounter++ + ".TXT"), new DocumentContent(("Content of File " + i).getBytes()));
                this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
                memoryMap.put(document.getDocumentFQN(), document.getDocumentContent());
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            log.debug("delete LIST OF FILES IN DOCUMENTSAFE: " + this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).size());
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            log.debug("delete LIST OF FILES IN TX: " + this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).getFilesWithVersion().size());
            for (j = 0; j < numberOfFilesToDeletePerTx; ++j) {
                bucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToDelete = ThreadLocalRandom.current().nextInt(0, currentNumberOfFiles);
                log.debug("Transaction number " + i + " has " + currentNumberOfFiles + " files");
                log.debug("Index to delete is " + indexToDelete);
                this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToDelete));
                memoryMap.remove(bucketContentFQN.getFiles().get(indexToDelete));
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            log.debug("overwrite LIST OF FILES IN DOCUMENTSAFE: " + this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).size());
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            log.debug("overwrite LIST OF FILES IN TX: " + this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).getFilesWithVersion().size());
            for (j = 0; j < numberOfFilesToOverwritePerTx; ++j) {
                bucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToOverwrite = ThreadLocalRandom.current().nextInt(0, currentNumberOfFiles);
                DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToOverwrite));
                DSDocument newDsDocument = new DSDocument(dsDocument.getDocumentFQN(), new DocumentContent((new String(dsDocument.getDocumentContent().getValue()) + " overwritten in tx ").getBytes()));
                this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, newDsDocument);
                memoryMap.put(newDsDocument.getDocumentFQN(), newDsDocument.getDocumentContent());
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        TxBucketContentFQN bucketContentFQN2 = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        log.debug("LIST OF FILES IN TRANSACTIONAL LAYER: " + bucketContentFQN2.toString());
        Assert.assertEquals((long)memoryMap.keySet().size(), (long)bucketContentFQN2.getFiles().size());
        bucketContentFQN2.getFiles().forEach(documentFQN -> {
            DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
            Assert.assertArrayEquals((byte[])((DocumentContent)memoryMap.get(documentFQN)).getValue(), (byte[])dsDocument.getDocumentContent().getValue());
            log.debug(documentFQN + " checked!");
        });
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        Assert.assertEquals((long)expectedNumberOfFilesAfterIteration, (long)bucketContentFQN2.getFiles().size());
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        int finalNumberOfDocuments = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).getFilesWithVersion().size();
        log.debug("overwrite LIST OF FILES IN TX: " + finalNumberOfDocuments);
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        log.debug("finally LIST OF FILES IN DOCUMENTSAFE: " + this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).size());
        this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).forEach(el -> log.debug(el.toString()));
        st.stop();
        Assert.assertEquals((long)expectedNumberOfFilesAfterIteration, (long)finalNumberOfDocuments);
        log.debug("time for test " + st.toString());
        ((CleanupLogic)Mockito.verify((Object)cl, (VerificationMode)Mockito.atLeast((int)1))).cleanupTxHistory((DocumentSafeService)Mockito.any(), (UserIDAuth)Mockito.any(), (TransactionInformationList)Mockito.any());
    }

    @Test
    public void forceCleanupInParallel() {
        int i;
        DSDocument document = new DSDocument(new DocumentFQN("folder/file.txt"), new DocumentContent("Content of File".getBytes()));
        int numberOfTx = 5;
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        for (int i2 = 0; i2 < numberOfTx; ++i2) {
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).forEach(el -> log.debug(el.toString()));
        Assert.assertEquals((long)(2 * numberOfTx + 1), (long)this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE).size());
        int PARALLEL_INSTANCES = 2;
        Semaphore semaphore = new Semaphore(PARALLEL_INSTANCES);
        CountDownLatch countDownLatch = new CountDownLatch(PARALLEL_INSTANCES);
        semaphore.acquire(PARALLEL_INSTANCES);
        ARunnable[] runnables = new ARunnable[PARALLEL_INSTANCES];
        Thread[] instances = new Thread[PARALLEL_INSTANCES];
        for (i = 0; i < PARALLEL_INSTANCES; ++i) {
            runnables[i] = new ARunnable(semaphore, countDownLatch, this.userIDAuth);
            instances[i] = new Thread(runnables[i]);
            instances[i].start();
        }
        Thread.currentThread();
        Thread.sleep(100L);
        log.debug("start " + PARALLEL_INSTANCES + " threads concurrently now");
        semaphore.release(PARALLEL_INSTANCES);
        log.debug("wait for " + PARALLEL_INSTANCES + " to finsih");
        countDownLatch.await();
        log.debug(PARALLEL_INSTANCES + " threadas have finished");
        for (i = 0; i < PARALLEL_INSTANCES; ++i) {
            log.debug(runnables[i].instanceID + " -> " + runnables[i].ok);
            Assert.assertTrue((boolean)runnables[i].ok);
        }
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ParallelCommitTxTest.ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        private TransactionalDocumentSafeService transactionalFileStorage;
        private UserIDAuth userIDAuth;
        private CountDownLatch countDownLatch;
        private DSDocument document;
        public boolean ok = false;
        public Exception exception;

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, UserIDAuth userIDAuth) {
            this.sem = sem;
            this.userIDAuth = userIDAuth;
            this.countDownLatch = countDownLatch;
            this.document = new DSDocument(new DocumentFQN("folder/file" + this.instanceID + ".txt"), new DocumentContent(("Content of File " + this.instanceID).getBytes()));
            SimpleRequestMemoryContextImpl requestMemoryContext = new SimpleRequestMemoryContextImpl();
            DocumentSafeServiceImpl dss = new DocumentSafeServiceImpl(DFSConnectionFactory.get());
            this.transactionalFileStorage = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestMemoryContext, (DocumentSafeService)dss);
        }

        @Override
        public void run() {
            try {
                this.transactionalFileStorage.beginTransaction(this.userIDAuth);
                this.transactionalFileStorage.txStoreDocument(this.userIDAuth, this.document);
                this.sem.acquire();
                LOGGER.info("Thread " + this.instanceID + " now tries do end tx");
                this.transactionalFileStorage.endTransaction(this.userIDAuth);
                this.sem.release();
                this.ok = true;
                LOGGER.info("Thread " + this.instanceID + " successfully finished transaction");
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

