/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.transactional.exceptions.TxParallelCommittingException;
import de.adorsys.docusafe.transactional.impl.TxIDHashMap;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.impl.helper.ParallelTransactionLogic;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTransactionLogicTest {
    private static final Logger log = LoggerFactory.getLogger(ParallelTransactionLogicTest.class);
    private static final TxID OLD_TX_ID = new TxID("OLD_TX");
    private static final TxID CURRENT_TX_ID = new TxID("CURRENT_TX");
    private static final TxID PARALLEL_TX_ID_1 = new TxID("PARALLEL_TX_1");
    private static final TxID PARALLEL_TX_ID_2 = new TxID("PARALLEL_TX_2");
    private static final TxID LAST_COMMIT_TX = new TxID("LAST_COMMIT_TX");

    @Test
    public void parallelCreationSameFile() {
        log.info("parallelCreationSameFile");
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)LAST_COMMIT_TX);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)PARALLEL_TX_ID_1);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).lastCommitedTxID(OLD_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        this.checkConflictFile(new DocumentFQN("A"));
    }

    @Test
    public void parallelCreationDifferentFiles() {
        log.info("parallelCreationDifferentFiles");
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)LAST_COMMIT_TX);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)PARALLEL_TX_ID_1);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        endStateMap.put((Object)new DocumentFQN("D"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(LAST_COMMIT_TX).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        TxIDHashMapWrapper result = ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx);
        TxIDHashMap expected = new TxIDHashMap();
        expected.putAll((Map)lastCommitMap);
        expected.putAll((Map)endStateMap);
        Assert.assertEquals((Object)expected, (Object)result.getMap());
    }

    @Test
    public void readFileUpdatedInParallelTx() {
        log.info("readFileUpdatedInParallelTx");
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)LAST_COMMIT_TX);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        documentsReadInTx.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        this.checkConflictFile(new DocumentFQN("A"));
    }

    @Test
    public void readFileDeletedInParallelTx() {
        log.info("readFileDeletedInParallelTx");
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)LAST_COMMIT_TX);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        documentsReadInTx.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        this.checkConflictFile(new DocumentFQN("B"));
    }

    @Test
    public void updateFileCDeletedInParallelTx() {
        log.info("updateFileCreatedAndDeletedInParallelTx");
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)LAST_COMMIT_TX);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)CURRENT_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        this.checkConflictFile(new DocumentFQN("A"));
    }

    @Test
    public void createFileCreatedInParallelTx() {
        log.info("createFileCreatedInParallelTx");
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)LAST_COMMIT_TX);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        this.checkConflictFile(new DocumentFQN("B"));
    }

    @Test
    public void readFileUnchancedInParallelTx() {
        log.info("readFileUnchancedInParallelTx");
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(OLD_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("C"), (Object)PARALLEL_TX_ID_1);
        lastCommitMap.put((Object)new DocumentFQN("D"), (Object)PARALLEL_TX_ID_2);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(LAST_COMMIT_TX).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(OLD_TX_ID).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        documentsReadInTx.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper result = ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx);
        TxIDHashMap expected = lastCommitMap;
        Assert.assertEquals((Object)expected, (Object)result.getMap());
    }

    private void checkConflictFile(DocumentFQN a) {
        Exception e = CatchException.caughtException();
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)(e instanceof TxParallelCommittingException));
        TxParallelCommittingException p = (TxParallelCommittingException)e;
        Assert.assertEquals((Object)a, (Object)((TxParallelCommittingException)e).getConflictDocument());
    }
}

