/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.DocumentContent;
import de.adorsys.docusafe.service.api.types.UserIDAuth;
import de.adorsys.docusafe.transactional.RequestMemoryContext;
import de.adorsys.docusafe.transactional.ThreadMemoryContextImpl;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import de.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCommitTxTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelCommitTxTest.class);
    private static final int PARALLEL_INSTANCES = 5;
    private static final String FILENAME = "paralleltest.txt";

    @Test
    public void parallelCommits() {
        ThreadMemoryContextImpl requestMemoryContext = new ThreadMemoryContextImpl();
        DocumentSafeServiceImpl dssi = new DocumentSafeServiceImpl(DFSConnectionFactory.get());
        TransactionalDocumentSafeServiceImpl transactionalFileStorage = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestMemoryContext, (DocumentSafeService)dssi);
        try {
            Semaphore semaphore = new Semaphore(5);
            CountDownLatch countDownLatch = new CountDownLatch(5);
            semaphore.acquire(5);
            ARunnable[] runnables = new ARunnable[5];
            Thread[] instances = new Thread[5];
            for (int i = 0; i < 5; ++i) {
                runnables[i] = new ARunnable(semaphore, countDownLatch, (TransactionalDocumentSafeService)transactionalFileStorage, this.userIDAuth);
                instances[i] = new Thread(runnables[i]);
                instances[i].start();
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            transactionalFileStorage.createUser(this.userIDAuth);
            DocumentFQN documentFQN = new DocumentFQN(FILENAME);
            DocumentContent documentContent = new DocumentContent("very first".getBytes());
            DSDocument document = new DSDocument(documentFQN, documentContent);
            transactionalFileStorage.beginTransaction(this.userIDAuth);
            LOGGER.debug("FIRST TXID");
            Assert.assertFalse((boolean)transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
            transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
            Assert.assertTrue((boolean)transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
            transactionalFileStorage.endTransaction(this.userIDAuth);
            LOGGER.debug("start 5 threads concurrently now");
            semaphore.release(5);
            LOGGER.debug("wait for 5 to finsih");
            countDownLatch.await();
            LOGGER.debug("5 threadas have finished");
            HashSet<Integer> winner = new HashSet<Integer>();
            for (int i = 0; i < 5; ++i) {
                winner.add(i);
            }
            int errorCounter = 0;
            for (int i = 0; i < 5; ++i) {
                if (runnables[i].ok) continue;
                LOGGER.error("THREAD " + runnables[i].instanceID + " error " + ++errorCounter + " " + runnables[i].exception.getMessage());
                winner.remove(runnables[i].instanceID);
            }
            Assert.assertEquals((long)4L, (long)errorCounter);
            Assert.assertEquals((long)1L, (long)winner.size());
            Integer[] winnerInts = new Integer[winner.size()];
            winner.toArray(winnerInts);
            Integer winnerInstanceID = winnerInts[0];
            LOGGER.info("=================================================================================================");
            LOGGER.info("the winner of the 5 instances is thread number " + winnerInstanceID);
            transactionalFileStorage.beginTransaction(this.userIDAuth);
            DSDocument dsDocument = transactionalFileStorage.txReadDocument(this.userIDAuth, new DocumentFQN(FILENAME));
            LOGGER.info("Content found is " + new String(dsDocument.getDocumentContent().getValue()));
            DocumentContent expectedContent = new DocumentContent(("Thread Number " + winnerInstanceID).getBytes());
            LOGGER.info("expected Content  is " + new String(expectedContent.getValue()));
            Assert.assertEquals((Object)expectedContent, (Object)dsDocument.getDocumentContent());
            transactionalFileStorage.endTransaction(this.userIDAuth);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        private TransactionalDocumentSafeService transactionalFileStorage;
        private UserIDAuth userIDAuth;
        private CountDownLatch countDownLatch;
        public boolean ok = false;
        public Exception exception;

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, TransactionalDocumentSafeService transactionalFileStorage, UserIDAuth userIDAuth) {
            this.sem = sem;
            this.transactionalFileStorage = transactionalFileStorage;
            this.userIDAuth = userIDAuth;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DocumentFQN documentFQN = new DocumentFQN(ParallelCommitTxTest.FILENAME);
                DocumentContent documentContent = new DocumentContent(("Thread Number " + this.instanceID).getBytes());
                DSDocument document = new DSDocument(documentFQN, documentContent);
                this.sem.acquire();
                this.transactionalFileStorage.beginTransaction(this.userIDAuth);
                this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
                this.transactionalFileStorage.endTransaction(this.userIDAuth);
                this.sem.release();
                this.ok = true;
                LOGGER.info("Thread " + this.instanceID + " successfully wrote file " + ParallelCommitTxTest.FILENAME + " with content \"" + new String(documentContent.getValue()) + "\"");
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

