/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleUserSameContextTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleUserSameContextTest.class);

    @Test
    public void twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        this.transactionalDocumentSafeService.createUser(this.systemUserIDAuth);
        DSDocument document1 = this.createDocument("file1");
        DSDocument document2 = this.createDocument("file2");
        LOGGER.debug("user1 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 cant see the not yet created document " + document1.getDocumentFQN());
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 creates " + document1.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document1);
        LOGGER.debug("user1 can see his own documents " + document1.getDocumentFQN());
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user2 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.systemUserIDAuth);
        LOGGER.debug("user2 cant see documents of user1");
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.systemUserIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user2 still cant see documents of user1");
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.systemUserIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user2 creates " + document2.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.systemUserIDAuth, document2);
        LOGGER.debug("user2 cant see the new document");
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.systemUserIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user1 cant do anything withoud opening another tx");
        CatchException.catchException(() -> this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document1.getDocumentFQN()));
        Assert.assertNotNull((Object)CatchException.caughtException());
        LOGGER.debug("user1 starts another TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 can see his own documents " + document1.getDocumentFQN());
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 cant see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user2 ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.systemUserIDAuth);
        LOGGER.debug("user1 still cant see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user1 ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user1 starts another TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user2 starts another TX");
        this.transactionalDocumentSafeService.beginTransaction(this.systemUserIDAuth);
        LOGGER.debug("user1 will never see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user2 will never see documents of user1 " + document1.getDocumentFQN());
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.systemUserIDAuth, document1.getDocumentFQN()));
    }
}

