/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl.helper;

import com.googlecode.catchexception.CatchException;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.transactional.impl.LastCommitedTxID;
import de.adorsys.docusafe.transactional.impl.TxIDHashMap;
import de.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import de.adorsys.docusafe.transactional.impl.helper.ParallelTransactionLogic;
import de.adorsys.docusafe.transactional.types.TxID;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTransactionLogicTest {
    private static final Logger log = LoggerFactory.getLogger(ParallelTransactionLogicTest.class);
    private static final TxID OLD_TX_ID = new TxID("ooo");
    private static final TxID CURRENT_TX_ID = new TxID("ccc");
    private static final TxID PARALLEL_TX_ID = new TxID("ppp1");
    private static final TxID PARALLEL_TX_ID_2 = new TxID("ppp2");

    @Test
    public void parallelCreationSameFile() {
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)PARALLEL_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)PARALLEL_TX_ID);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }

    @Test
    public void parallelCreationDifferentFiles() {
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)PARALLEL_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)PARALLEL_TX_ID);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        endStateMap.put((Object)new DocumentFQN("D"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        TxIDHashMapWrapper result = ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx);
        log.info(result.toString());
    }

    @Test
    public void readFileUpdatedInParallelTx() {
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)PARALLEL_TX_ID);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        documentsReadInTx.put((Object)new DocumentFQN("A"), (Object)CURRENT_TX_ID);
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }

    @Test
    public void readFileDeletedInParallelTx() {
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)PARALLEL_TX_ID);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        documentsReadInTx.put((Object)new DocumentFQN("B"), (Object)CURRENT_TX_ID);
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }

    @Test
    public void createFileCreatedAndDeletedInParallelTx() {
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("C"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)PARALLEL_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("C"), (Object)PARALLEL_TX_ID);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)CURRENT_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        TxIDHashMapWrapper result = ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx);
        log.info(result.toString());
    }

    @Test
    public void createFileCreatedInParallelTx() {
        TxIDHashMap beginStateMap = new TxIDHashMap();
        beginStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        beginStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        TxIDHashMapWrapper stateAtBeginOfCurrentTx = new TxIDHashMapWrapper().toBuilder().currentTxID(CURRENT_TX_ID).map(beginStateMap).build();
        TxIDHashMap lastCommitMap = new TxIDHashMap();
        lastCommitMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("C"), (Object)PARALLEL_TX_ID);
        lastCommitMap.put((Object)new DocumentFQN("D"), (Object)PARALLEL_TX_ID_2);
        TxIDHashMapWrapper stateLastCommittedTx = new TxIDHashMapWrapper().toBuilder().currentTxID(PARALLEL_TX_ID).map(lastCommitMap).build();
        TxIDHashMap endStateMap = new TxIDHashMap();
        endStateMap.put((Object)new DocumentFQN("A"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("B"), (Object)OLD_TX_ID);
        endStateMap.put((Object)new DocumentFQN("C"), (Object)CURRENT_TX_ID);
        TxIDHashMapWrapper stateAtEndOfCurrentTx = new TxIDHashMapWrapper().toBuilder().lastCommitedTxID(new LastCommitedTxID(PARALLEL_TX_ID.getValue())).currentTxID(CURRENT_TX_ID).map(endStateMap).build();
        TxIDHashMap documentsReadInTx = new TxIDHashMap();
        CatchException.catchException(() -> ParallelTransactionLogic.join((TxIDHashMapWrapper)stateLastCommittedTx, (TxIDHashMapWrapper)stateAtBeginOfCurrentTx, (TxIDHashMapWrapper)stateAtEndOfCurrentTx, (TxIDHashMap)documentsReadInTx));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }
}

