/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional.impl.helper;

import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.transactional.impl.helper.BucketContentFromHashMapHelper;
import de.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import de.adorsys.docusafe.transactional.types.TxID;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketContentFromHashMapHelperTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketContentFromHashMapHelperTest.class);
    Map<DocumentFQN, TxID> keys = new HashMap<DocumentFQN, TxID>();

    @Before
    public void init() {
        this.keys.put(new DocumentFQN("/a/file1"), new TxID());
        this.keys.put(new DocumentFQN("/a/file2"), new TxID());
        this.keys.put(new DocumentFQN("/a/b/c/file1"), new TxID());
        this.keys.put(new DocumentFQN("/a/b/c/file2"), new TxID());
        this.keys.put(new DocumentFQN("/a/b/c/file3"), new TxID());
        this.keys.put(new DocumentFQN("/a/b/c/file4"), new TxID());
    }

    @Test
    public void testRecursiveWithFolder() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("a"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)6L, (long)a.getFiles().size());
    }

    @Test
    public void testRecursiveWithRoot() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)6L, (long)a.getFiles().size());
    }

    @Test
    public void testRecursiveWithNonExsistantFolder() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/b"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
    }

    @Test
    public void testNonRecursiveWithFolder() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("a"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)2L, (long)a.getFiles().size());
    }

    @Test
    public void testNonRecursiveWithRoot() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
    }

    @Test
    public void testNonRecursiveWithNonExsistantFolder() {
        TxBucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/b"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
    }
}

