/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import de.adorsys.docusafe.business.DocumentSafeService;
import de.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.transactional.RequestMemoryContext;
import de.adorsys.docusafe.transactional.SimpleRequestMemoryContextImpl;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import de.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameUserSameTimeDifferentRequestsTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SameUserSameTimeDifferentRequestsTest.class);
    SimpleRequestMemoryContextImpl secondRequestMemoryContext = new SimpleRequestMemoryContextImpl();
    TransactionalDocumentSafeService secondTransactionalDocumentSafeService = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)this.secondRequestMemoryContext, (DocumentSafeService)new DocumentSafeServiceImpl(DFSConnectionFactory.get()));

    @Test
    public void a() {
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DSDocument document1 = this.createDocument("file1");
        DSDocument document2 = this.createDocument("file2");
        DSDocument document3 = this.createDocument("file3");
        DSDocument document4 = this.createDocument("file4");
        DSDocument document5 = this.createDocument("file5");
        LOGGER.debug("user1 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 creates " + document1.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document1);
        LOGGER.debug("user1 ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user1 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 in a new context starts another TX");
        this.secondTransactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 in the second tx creates " + document2.getDocumentFQN());
        this.secondTransactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document2);
        LOGGER.debug("user1 in the first tx creates " + document2.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document2);
        LOGGER.debug("user1 first tx ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user1 second tx ends TX and gets exception");
        CatchException.catchException(() -> this.secondTransactionalDocumentSafeService.endTransaction(this.userIDAuth));
        Assert.assertNotNull((Object)CatchException.caughtException());
        LOGGER.debug("user1 in a new context starts another TX");
        this.secondTransactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 in the first tx creates " + document2.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document2);
        LOGGER.debug("user1 in the first tx creates " + document5.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document5);
        LOGGER.debug("user1 first tx ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user1 starts TX");
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        LOGGER.debug("user1 in the first tx creates " + document2.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document2);
        LOGGER.debug("user1 in the first tx creates " + document3.getDocumentFQN());
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document3);
        LOGGER.debug("user1 in the first tx DELETES " + document5.getDocumentFQN());
        this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, document5.getDocumentFQN());
        LOGGER.debug("user1 first tx ends TX");
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        LOGGER.debug("user1 in the second context creates " + document4.getDocumentFQN());
        this.secondTransactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document4);
        LOGGER.debug("user1 second context ends TX");
        CatchException.catchException(() -> this.secondTransactionalDocumentSafeService.endTransaction(this.userIDAuth));
        LOGGER.info("should be reached");
    }
}

