/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.transactional;

import de.adorsys.docusafe.business.types.DSDocument;
import de.adorsys.docusafe.business.types.DocumentFQN;
import de.adorsys.docusafe.service.api.types.DocumentContent;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import de.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyUserCreationTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceTest.class);

    public void createUserAfterBegin() {
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }
}

