/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl.helper;

import java.util.HashSet;
import java.util.Set;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.transactional.impl.helper.BucketContentFromHashMapHelper;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketContentFromHashMapHelperTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketContentFromHashMapHelperTest.class);
    Set<DocumentFQN> keys = new HashSet<DocumentFQN>();

    @Before
    public void init() {
        this.keys.add(new DocumentFQN("/a/file1"));
        this.keys.add(new DocumentFQN("/a/file2"));
        this.keys.add(new DocumentFQN("/a/b/c/file1"));
        this.keys.add(new DocumentFQN("/a/b/c/file2"));
        this.keys.add(new DocumentFQN("/a/b/c/file3"));
        this.keys.add(new DocumentFQN("/a/b/c/file4"));
    }

    @Test
    public void testRecursiveWithFolder() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("a"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)6L, (long)a.getFiles().size());
        Assert.assertEquals((long)2L, (long)a.getDirectories().size());
    }

    @Test
    public void testRecursiveWithRoot() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)6L, (long)a.getFiles().size());
        Assert.assertEquals((long)3L, (long)a.getDirectories().size());
    }

    @Test
    public void testRecursiveWithNonExsistantFolder() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/b"), (ListRecursiveFlag)ListRecursiveFlag.TRUE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
        Assert.assertEquals((long)0L, (long)a.getDirectories().size());
    }

    @Test
    public void testNonRecursiveWithFolder() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("a"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)2L, (long)a.getFiles().size());
        Assert.assertEquals((long)1L, (long)a.getDirectories().size());
    }

    @Test
    public void testNonRecursiveWithRoot() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
        Assert.assertEquals((long)1L, (long)a.getDirectories().size());
    }

    @Test
    public void testNonRecursiveWithNonExsistantFolder() {
        BucketContentFQN a = BucketContentFromHashMapHelper.list(this.keys, (DocumentDirectoryFQN)new DocumentDirectoryFQN("/b"), (ListRecursiveFlag)ListRecursiveFlag.FALSE);
        a.getFiles().forEach(file -> LOGGER.debug("file: " + file));
        a.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        Assert.assertEquals((long)0L, (long)a.getFiles().size());
        Assert.assertEquals((long)0L, (long)a.getDirectories().size());
    }
}

