/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.exceptions.TxInnerException;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalFileStorageTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalFileStorageTest.class);

    @Test
    public void testOverwrite() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        BucketContentFQN bucketContentFQN = this.transactionalFileStorage.txListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN.getFiles().get(0));
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)documentFQN, (Object)dsDocument.getDocumentFQN());
        Assert.assertArrayEquals((byte[])document.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        DSDocument newDocument = null;
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        BucketContentFQN bucketContentFQN2 = this.transactionalFileStorage.txListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN2.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN2.getFiles().get(0));
        DSDocument dsDocument2 = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        newDocument = new DSDocument(documentFQN, new DocumentContent("new content".getBytes()), dsDocument2.getDsDocumentMetaInfo());
        this.transactionalFileStorage.txStoreDocument(this.userIDAuth, newDocument);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])newDocument.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
    }

    @Test(expected=TxInnerException.class)
    public void innerTxNotImplementedYet() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
    }

    @Test
    public void testCreateAndChange() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent1 = new DocumentContent("very first".getBytes());
        DocumentContent documentContent2 = new DocumentContent("second".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent1, documentMetaInfo);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("FIRST TXID ");
        Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(2);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("SECOND TXID ");
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        DSDocument document2 = new DSDocument(documentFQN, documentContent2, documentMetaInfo);
        this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document2);
        this.requestMemoryContext.switchToUser(3);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("THIRD TXID ");
        this.requestMemoryContext.switchToUser(2);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(4);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("FOURTH TXID ");
        this.requestMemoryContext.switchToUser(3);
        dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        this.requestMemoryContext.switchToUser(4);
        dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent2.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        this.requestMemoryContext.switchToUser(4);
        BucketContentFQN list = this.transactionalFileStorage.txListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        list.getDirectories().forEach(dir -> LOGGER.debug("directory : " + dir));
        list.getFiles().forEach(file -> LOGGER.debug("file:" + file));
        Assert.assertEquals((long)1L, (long)list.getFiles().size());
        Assert.assertEquals((long)1L, (long)list.getDirectories().size());
    }

    @Test
    public void testDelete() {
        DocumentFQN docFQN;
        int i;
        this.transactionalFileStorage.createUser(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        int N = 5;
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            DocumentContent docContent = new DocumentContent(("Content_" + i).getBytes());
            DSDocumentMetaInfo docMetaInfo = new DSDocumentMetaInfo();
            DSDocument doc = new DSDocument(docFQN, docContent, docMetaInfo);
            this.transactionalFileStorage.txStoreDocument(this.userIDAuth, doc);
        }
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(2);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(3);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(4);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            this.requestMemoryContext.switchToUser(2);
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
            this.transactionalFileStorage.txDeleteDocument(this.userIDAuth, docFQN);
            Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            this.requestMemoryContext.switchToUser(3);
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
            this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.requestMemoryContext.switchToUser(3);
        this.transactionalFileStorage.txDeleteFolder(this.userIDAuth, new DocumentDirectoryFQN("folder1"));
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            this.requestMemoryContext.switchToUser(3);
            Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
            this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, docFQN));
        }
        this.requestMemoryContext.switchToUser(3);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.requestMemoryContext.switchToUser(4);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
    }

    @Test(expected=TxNotActiveException.class)
    public void testEndTxTwice() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
    }
}

