/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCommitTxTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelCommitTxTest.class);
    private static final int PARALLEL_INSTANCES = 5;
    private static final String FILENAME = "paralleltest.txt";

    @Test
    public void parallelCommits() {
        try {
            Semaphore semaphore = new Semaphore(5);
            CountDownLatch countDownLatch = new CountDownLatch(5);
            semaphore.acquire(5);
            ARunnable[] runnables = new ARunnable[5];
            Thread[] instances = new Thread[5];
            for (int i = 0; i < 5; ++i) {
                runnables[i] = new ARunnable(semaphore, countDownLatch, this.transactionalFileStorage, this.userIDAuth);
                instances[i] = new Thread(runnables[i]);
                instances[i].start();
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            this.transactionalFileStorage.createUser(this.userIDAuth);
            DocumentFQN documentFQN = new DocumentFQN(FILENAME);
            DocumentContent documentContent = new DocumentContent("very first".getBytes());
            DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
            DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
            this.transactionalFileStorage.beginTransaction(this.userIDAuth);
            LOGGER.debug("FIRST TXID");
            Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
            this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
            this.transactionalFileStorage.endTransaction(this.userIDAuth);
            LOGGER.debug("start 5 threads concurrently now");
            semaphore.release(5);
            LOGGER.debug("wait for 5 to finsih");
            countDownLatch.await();
            LOGGER.debug("5 threadas have finished");
            int errorCounter = 0;
            for (int i = 0; i < 5; ++i) {
                if (runnables[i].ok) continue;
                LOGGER.error("error " + ++errorCounter + " " + runnables[i].exception.getMessage());
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        private TransactionalDocumentSafeService transactionalFileStorage;
        private UserIDAuth userIDAuth;
        private CountDownLatch countDownLatch;
        public boolean ok = false;
        public Exception exception;

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, TransactionalDocumentSafeService transactionalFileStorage, UserIDAuth userIDAuth) {
            this.sem = sem;
            this.transactionalFileStorage = transactionalFileStorage;
            this.userIDAuth = userIDAuth;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DocumentFQN documentFQN = new DocumentFQN(ParallelCommitTxTest.FILENAME);
                DocumentContent documentContent = new DocumentContent(("Thread Number " + this.instanceID).getBytes());
                DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
                DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
                this.sem.acquire();
                this.transactionalFileStorage.beginTransaction(this.userIDAuth);
                this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
                this.transactionalFileStorage.endTransaction(this.userIDAuth);
                this.sem.release();
                this.ok = true;
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

