/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl.helper;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.transactional.exceptions.TxBaseException;
import org.adorsys.docusafe.transactional.exceptions.TxParallelCommittingException;
import org.adorsys.docusafe.transactional.impl.LastCommitedTxID;
import org.adorsys.docusafe.transactional.impl.TxIDHashMap;
import org.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import org.adorsys.docusafe.transactional.types.TxID;

public class ParallelTransactionLogic {
    public static TxIDHashMapWrapper join(TxIDHashMapWrapper stateLastCommittedTx, TxIDHashMapWrapper stateAtBeginOfCurrentTx, TxIDHashMapWrapper stateAtEndOfCurrentTx, TxIDHashMap documentsReadInTx) {
        TxID lastCommitedTxID = stateLastCommittedTx.getCurrentTxID();
        if (lastCommitedTxID != null && lastCommitedTxID.equals((Object)stateAtBeginOfCurrentTx.getLastCommitedTxID())) {
            throw new TxBaseException("Nothing to merge. No parallel transactions committed.");
        }
        Set docsTouched = stateAtEndOfCurrentTx.getMap().entrySet().stream().filter(e -> ((TxID)((Object)((Object)e.getValue()))).equals((Object)stateAtEndOfCurrentTx.getCurrentTxID())).map(Map.Entry::getKey).collect(Collectors.toSet());
        docsTouched.addAll(documentsReadInTx.keySet());
        MapDifference currentTxDiff = Maps.difference((Map)stateAtBeginOfCurrentTx.getMap(), (Map)stateAtEndOfCurrentTx.getMap());
        docsTouched.addAll(currentTxDiff.entriesOnlyOnLeft().keySet());
        MapDifference parallelTxDiff = Maps.difference((Map)stateLastCommittedTx.getMap(), (Map)stateAtBeginOfCurrentTx.getMap());
        ArrayList docsTouchedInParallel = new ArrayList(parallelTxDiff.entriesDiffering().keySet());
        docsTouchedInParallel.addAll(parallelTxDiff.entriesOnlyOnLeft().keySet());
        docsTouchedInParallel.addAll(parallelTxDiff.entriesOnlyOnRight().keySet());
        for (DocumentFQN d : docsTouched) {
            if (!docsTouchedInParallel.contains(d)) continue;
            throw new TxParallelCommittingException(stateAtBeginOfCurrentTx.getCurrentTxID(), stateLastCommittedTx.getCurrentTxID(), d.getValue());
        }
        return TxIDHashMapWrapper.builder().lastCommitedTxID(new LastCommitedTxID(stateLastCommittedTx.getCurrentTxID().getValue())).currentTxID(new TxID()).beginTx(new Date()).endTx(new Date()).map(stateAtEndOfCurrentTx.getMap()).mergedTxID(stateAtEndOfCurrentTx.getCurrentTxID()).build();
    }
}

