/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl.helper;

import java.util.HashSet;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.service.api.types.UserIDAuth;
import org.adorsys.docusafe.transactional.impl.LastCommitedTxID;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import org.adorsys.docusafe.transactional.impl.helper.TransactionInformation;
import org.adorsys.docusafe.transactional.impl.helper.TransactionInformationList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupLogic {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupLogic.class);

    public static TransactionInformationList cleaupTxHistory(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, TransactionInformationList transactionInformationList) {
        TxIDHashMapWrapper txIDHashMapWrapper;
        TransactionInformation tuple;
        int size = transactionInformationList.size();
        if (size < 1) {
            return transactionInformationList;
        }
        LOGGER.debug("cleanup has to be done for " + (size - 1) + " previously commited transactions");
        HashSet allPrevousFiles = new HashSet();
        for (int i = 0; i < size - 1; ++i) {
            tuple = (TransactionInformation)transactionInformationList.get(i);
            txIDHashMapWrapper = TxIDHashMapWrapper.readHashMapOfTx(documentSafeService, userIDAuth, new LastCommitedTxID(tuple.getCurrentTxID().getValue()));
            txIDHashMapWrapper.getMap().forEach((documentFQN, txID) -> allPrevousFiles.add(TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(documentFQN, txID)));
        }
        HashSet currentFiles = new HashSet();
        tuple = (TransactionInformation)transactionInformationList.get(size - 1);
        txIDHashMapWrapper = TxIDHashMapWrapper.readHashMapOfTx(documentSafeService, userIDAuth, new LastCommitedTxID(tuple.getCurrentTxID().getValue()));
        txIDHashMapWrapper.getMap().forEach((documentFQN, txID) -> currentFiles.add(TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(documentFQN, txID)));
        LOGGER.debug("previous files size = " + allPrevousFiles.size());
        LOGGER.debug("current files size  = " + currentFiles.size());
        allPrevousFiles.removeAll(currentFiles);
        LOGGER.debug("previous files size after removeing all of current file = " + allPrevousFiles.size());
        allPrevousFiles.forEach(fileToDelte -> documentSafeService.deleteDocument(userIDAuth, fileToDelte));
        for (int i = 0; i < size - 1; ++i) {
            TransactionInformation tuple2 = (TransactionInformation)transactionInformationList.get(i);
            TxIDHashMapWrapper.deleteHashMapOfTx(documentSafeService, userIDAuth, new LastCommitedTxID(tuple2.getCurrentTxID().getValue()));
        }
        LOGGER.debug("expected HashMap to remain is " + (Object)((Object)((TransactionInformation)transactionInformationList.get(size - 1)).getCurrentTxID()));
        tuple = (TransactionInformation)transactionInformationList.get(size - 1);
        TransactionInformationList newTransactionInformationList = new TransactionInformationList();
        newTransactionInformationList.add(tuple);
        return newTransactionInformationList;
    }
}

