/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.electronicpeter.testtimelogger.LoggerAspect;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleUserSameContextTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        MultipleUserSameContextTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(MultipleUserSameContextTest.class);
    }

    @Test
    public void twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext() {
        MultipleUserSameContextTest.twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    private DSDocument createDocument(String name) {
        DocumentFQN documentFQN = new DocumentFQN(name);
        DocumentContent documentContent = new DocumentContent(("CONTENT OF FILE " + name).getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        return new DSDocument(documentFQN, documentContent, documentMetaInfo);
    }

    private static final /* synthetic */ void twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext_aroundBody0(MultipleUserSameContextTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.createUser(ajc$this.systemUserIDAuth);
        DSDocument document1 = ajc$this.createDocument("file1");
        DSDocument document2 = ajc$this.createDocument("file2");
        LOGGER.debug("user1 starts TX");
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("user1 cant see the not yet created document " + document1.getDocumentFQN());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 creates " + document1.getDocumentFQN());
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document1);
        LOGGER.debug("user1 can see his own documents " + document1.getDocumentFQN());
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user2 starts TX");
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.systemUserIDAuth);
        LOGGER.debug("user2 cant see documents of user1");
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.systemUserIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 ends TX");
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        LOGGER.debug("user2 still cant see documents of user1");
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.systemUserIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user2 creates " + document2.getDocumentFQN());
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.systemUserIDAuth, document2);
        LOGGER.debug("user2 cant see the new document");
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.systemUserIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user1 cant do anything withoud opening another tx");
        CatchException.catchException(() -> {
            boolean bl = this.transactionalFileStorage.txDocumentExists(this.userIDAuth, document1.getDocumentFQN());
        });
        Assert.assertNotNull((Object)CatchException.caughtException());
        LOGGER.debug("user1 starts another TX");
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("user1 can see his own documents " + document1.getDocumentFQN());
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document1.getDocumentFQN()));
        LOGGER.debug("user1 cant see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user2 ends TX");
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.systemUserIDAuth);
        LOGGER.debug("user1 still cant see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user1 ends TX");
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        LOGGER.debug("user1 starts another TX");
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("user2 starts another TX");
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.systemUserIDAuth);
        LOGGER.debug("user1 will never see documents of user2 " + document2.getDocumentFQN());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, document2.getDocumentFQN()));
        LOGGER.debug("user2 will never see documents of user1 " + document1.getDocumentFQN());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.systemUserIDAuth, document1.getDocumentFQN()));
    }

    private static final /* synthetic */ Object twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext_aroundBody1$advice(MultipleUserSameContextTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            MultipleUserSameContextTest.twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MultipleUserSameContextTest.java", MultipleUserSameContextTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "twoUsersCreateDocumenteInTheirOwnScopeButWithTheSameRequestContext", "org.adorsys.docusafe.transactional.MultipleUserSameContextTest", "", "", "", "void"), 21);
    }
}

