/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.transactional.impl.TxBucketContentFQNImpl;
import org.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;

public class BucketContentFromHashMapHelper {
    public static TxBucketContentFQN list(Map<DocumentFQN, TxID> documentTxMap, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        ArrayList candidates = new ArrayList();
        documentTxMap.keySet().forEach(documentFQN -> {
            if (documentFQN.getValue().startsWith(documentDirectoryFQN.getValue())) {
                candidates.add(new TxDocumentFQNWithVersion((DocumentFQN)documentFQN, new TxDocumentFQNVersion(((TxID)((Object)((Object)documentTxMap.get(documentFQN)))).getValue())));
            }
        });
        HashSet dirCandidates = new HashSet();
        candidates.forEach(candidate -> {
            DocumentFQN remainder = new DocumentFQN(candidate.getDocumentFQN().getValue().substring(documentDirectoryFQN.getValue().length()));
            String dirPath = remainder.getDocumentDirectory().getValue();
            StringTokenizer st = new StringTokenizer(dirPath, "/");
            String dirbase = documentDirectoryFQN.getValue();
            if (dirbase.length() == 1) {
                dirbase = "";
            }
            while (st.hasMoreElements()) {
                dirbase = dirbase + "/" + st.nextToken();
                dirCandidates.add(new DocumentDirectoryFQN(dirbase));
            }
        });
        if (recursiveFlag.equals((Object)ListRecursiveFlag.TRUE)) {
            TxBucketContentFQNImpl bucketContentFQN = new TxBucketContentFQNImpl();
            candidates.forEach(candidate -> bucketContentFQN.getFiles().add(candidate.getDocumentFQN()));
            dirCandidates.forEach(dirCandidate -> bucketContentFQN.getDirectories().add(dirCandidate));
            candidates.forEach(candidate -> bucketContentFQN.getFilesWithVersion().add((TxDocumentFQNWithVersion)candidate));
            return bucketContentFQN;
        }
        TxBucketContentFQNImpl bucketContentFQN = new TxBucketContentFQNImpl();
        candidates.forEach(candidate -> {
            DocumentFQN remainder = new DocumentFQN(candidate.getDocumentFQN().getValue().substring(documentDirectoryFQN.getValue().length()));
            if (remainder.getValue().lastIndexOf("/") == 0) {
                bucketContentFQN.getFiles().add(candidate.getDocumentFQN());
                bucketContentFQN.getFilesWithVersion().add((TxDocumentFQNWithVersion)candidate);
            }
        });
        HashSet dirs = new HashSet();
        dirCandidates.forEach(dirCandidate -> {
            DocumentDirectoryFQN remainder = new DocumentDirectoryFQN(dirCandidate.getValue().substring(documentDirectoryFQN.getValue().length()));
            if (remainder.getValue().lastIndexOf("/") == 0) {
                dirs.add(remainder);
            }
        });
        dirs.forEach(dir -> bucketContentFQN.getDirectories().add(dir));
        return bucketContentFQN;
    }
}

