/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl;

import java.util.Date;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.exceptions.TxInnerException;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionData;
import org.adorsys.docusafe.transactional.impl.NonTransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.transactional.impl.TxIDHashMap;
import org.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNVersion;
import org.adorsys.docusafe.transactional.types.TxDocumentFQNWithVersion;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.filesystem.exceptions.FileNotFoundException;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.adorsys.encobject.types.PublicKeyJWK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalDocumentSafeServiceImpl
extends NonTransactionalDocumentSafeServiceImpl
implements TransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceImpl.class);
    static final DocumentDirectoryFQN txMeta = new DocumentDirectoryFQN("meta.tx");
    static final DocumentDirectoryFQN txContent = new DocumentDirectoryFQN("tx");
    public static final String CURRENT_TRANSACTION_DATA = "CurrentTransactionData";

    public TransactionalDocumentSafeServiceImpl(RequestMemoryContext requestMemoryContext, DocumentSafeService documentSafeService) {
        super(requestMemoryContext, documentSafeService);
        LOGGER.debug("new Instance of TransactionalDocumentSafeServiceImpl");
    }

    @Override
    public void beginTransaction(UserIDAuth userIDAuth) {
        Date beginTxDate = new Date();
        CurrentTransactionData currentTransactionData = (CurrentTransactionData)this.requestMemoryContext.get(CURRENT_TRANSACTION_DATA);
        if (currentTransactionData != null) {
            throw new TxInnerException();
        }
        TxID currentTxID = new TxID();
        LOGGER.debug("beginTransaction " + currentTxID.getValue());
        TxIDHashMap txIDHashMap = TxIDHashMap.fromPreviousFileOrNew(this.documentSafeService, userIDAuth, currentTxID, beginTxDate);
        currentTransactionData = new CurrentTransactionData(currentTxID, txIDHashMap);
        this.requestMemoryContext.put(CURRENT_TRANSACTION_DATA, currentTransactionData);
    }

    @Override
    public void txStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("txStoreDocument " + dsDocument.getDocumentFQN().getValue() + " " + (Object)((Object)this.getCurrentTxID()));
        this.documentSafeService.storeDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocument(dsDocument, this.getCurrentTxID()));
        this.getCurrentTxIDHashMap().storeDocument(dsDocument.getDocumentFQN());
    }

    @Override
    public DSDocument txReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txReadDocument " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID()));
        TxID txidOfDocument = this.getCurrentTxIDHashMap().readDocument(documentFQN);
        DSDocument dsDocument = this.documentSafeService.readDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(documentFQN, txidOfDocument));
        return new DSDocument(documentFQN, dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    @Override
    public void txDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDeleteDocument " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID()));
        this.getCurrentTxIDHashMap().deleteDocument(documentFQN);
    }

    @Override
    public TxBucketContentFQN txListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        LOGGER.debug("txListDocuments " + (Object)((Object)this.getCurrentTxID()));
        TxIDHashMap txIDHashMap = this.getCurrentTxIDHashMap();
        return txIDHashMap.list(documentDirectoryFQN, recursiveFlag);
    }

    @Override
    public TxDocumentFQNVersion getVersion(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        TxBucketContentFQN txBucketContentFQN = this.txListDocuments(userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.FALSE);
        if (txBucketContentFQN.getFilesWithVersion().isEmpty()) {
            throw new FileNotFoundException(documentFQN.getValue(), null);
        }
        return ((TxDocumentFQNWithVersion)txBucketContentFQN.getFilesWithVersion().stream().findFirst().get()).getVersion();
    }

    @Override
    public boolean txDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDocumentExists " + documentFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID()));
        return this.getCurrentTxIDHashMap().documentExists(documentFQN);
    }

    @Override
    public void txDeleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        LOGGER.debug("txDeleteFolder " + documentDirectoryFQN.getValue() + " " + (Object)((Object)this.getCurrentTxID()));
        this.getCurrentTxIDHashMap().deleteFolder(documentDirectoryFQN);
    }

    @Override
    public void transferFromNonTxToTx(UserIDAuth userIDAuth, DocumentFQN nonTxFQN, DocumentFQN txFQN) {
        DSDocument nonTxDsDocument = this.nonTxReadDocument(userIDAuth, nonTxFQN);
        DSDocument txDsDocument = new DSDocument(txFQN, nonTxDsDocument.getDocumentContent(), nonTxDsDocument.getDsDocumentMetaInfo());
        this.txStoreDocument(userIDAuth, txDsDocument);
        this.getCurrentTransactionData().addNonTxFileToBeDeletedAfterCommit(nonTxFQN);
    }

    @Override
    public void endTransaction(UserIDAuth userIDAuth) {
        TxID txid = this.getCurrentTxID();
        LOGGER.debug("endTransaction " + txid.getValue());
        boolean changed = this.getCurrentTransactionData().anyDifferenceToInitalState();
        if (changed) {
            LOGGER.info("something has changed, so write down the new state");
            TxIDHashMap txIDHashMap = this.getCurrentTxIDHashMap();
            txIDHashMap.setEndTransactionDate(new Date());
            txIDHashMap.saveOnce(this.documentSafeService, userIDAuth);
            txIDHashMap.transactionIsOver(this.documentSafeService, userIDAuth);
            for (DocumentFQN doc : this.getCurrentTransactionData().getNonTxDocumentsToBeDeletedAfterCommit()) {
                try {
                    LOGGER.debug("delete file after commit " + doc);
                    this.nonTxDeleteDocument(userIDAuth, doc);
                }
                catch (BaseException e) {
                    LOGGER.warn("Exception is ignored. File deletion after commit does not raise exception");
                }
                catch (Exception e) {
                    new BaseException((Throwable)e);
                    LOGGER.warn("Exception is ignored. File deletion after commit does not raise exception");
                }
            }
        } else {
            LOGGER.info("nothing has changed, so nothing has to be written down");
        }
        this.setCurrentTransactionDataToNull();
    }

    public static DSDocument modifyTxDocument(DSDocument dsDocument, TxID txid) {
        return new DSDocument(TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(dsDocument.getDocumentFQN(), txid), dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    public static DocumentFQN modifyTxDocumentName(DocumentFQN origName, TxID txid) {
        return txContent.addName(origName.getValue() + "." + txid.getValue());
    }

    public static DocumentFQN modifyTxMetaDocumentName(DocumentFQN origName, TxID txid) {
        return txMeta.addName(origName.getValue() + "." + txid.getValue());
    }

    private TxID getCurrentTxID() {
        return this.getCurrentTransactionData().getCurrentTxID();
    }

    private TxIDHashMap getCurrentTxIDHashMap() {
        return this.getCurrentTransactionData().getCurrentTxHashMap();
    }

    private CurrentTransactionData getCurrentTransactionData() {
        CurrentTransactionData currentTransactionData = (CurrentTransactionData)this.requestMemoryContext.get(CURRENT_TRANSACTION_DATA);
        if (currentTransactionData == null) {
            throw new TxNotActiveException();
        }
        return currentTransactionData;
    }

    private void setCurrentTransactionDataToNull() {
        this.requestMemoryContext.put(CURRENT_TRANSACTION_DATA, null);
    }

    @Override
    public PublicKeyJWK findPublicEncryptionKey(UserID userID) {
        return this.documentSafeService.findPublicEncryptionKey(userID);
    }
}

