/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl;

import java.util.HashSet;
import java.util.Set;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.transactional.impl.TxIDHashMap;
import org.adorsys.docusafe.transactional.types.TxID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentTransactionData {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentTransactionData.class);
    private TxID currentTxID = null;
    private TxIDHashMap currentTxHashMap = null;
    private TxIDHashMap initialTxHashMap = null;
    private Set<DocumentFQN> nonTxDocumentsToBeDeletedAfterCommit = new HashSet<DocumentFQN>();

    public CurrentTransactionData(TxID currentTxID, TxIDHashMap currentTxHashMap) {
        this.currentTxID = currentTxID;
        this.currentTxHashMap = currentTxHashMap;
        this.initialTxHashMap = currentTxHashMap.clone();
    }

    public TxID getCurrentTxID() {
        return this.currentTxID;
    }

    public TxIDHashMap getCurrentTxHashMap() {
        return this.currentTxHashMap;
    }

    public boolean anyDifferenceToInitalState() {
        HashSet<DocumentFQN> currentFQNs = new HashSet<DocumentFQN>(this.currentTxHashMap.map.keySet());
        HashSet<DocumentFQN> initialFQNs = new HashSet<DocumentFQN>(this.initialTxHashMap.map.keySet());
        if (currentFQNs.size() > initialFQNs.size()) {
            currentFQNs.removeAll(initialFQNs);
            currentFQNs.forEach(fqn -> LOGGER.debug(" new file has been created: " + fqn));
            return true;
        }
        if (currentFQNs.size() < initialFQNs.size()) {
            initialFQNs.removeAll(currentFQNs);
            initialFQNs.forEach(fqn -> LOGGER.debug(" old file has been removed: " + fqn));
            return true;
        }
        for (DocumentFQN fqn2 : currentFQNs) {
            TxID initialTxID;
            if (!initialFQNs.contains(fqn2)) {
                LOGGER.debug(" old file has been removed: " + fqn2);
                return true;
            }
            TxID currentTxID = this.currentTxHashMap.map.get(fqn2);
            if (currentTxID.equals((Object)(initialTxID = this.initialTxHashMap.map.get(fqn2)))) continue;
            LOGGER.debug(" old file has changed:" + fqn2);
            return true;
        }
        LOGGER.debug(" nothing has changed");
        return false;
    }

    public void addNonTxFileToBeDeletedAfterCommit(DocumentFQN nonTxFQN) {
        this.nonTxDocumentsToBeDeletedAfterCommit.add(nonTxFQN);
    }

    public Set<DocumentFQN> getNonTxDocumentsToBeDeletedAfterCommit() {
        return this.nonTxDocumentsToBeDeletedAfterCommit;
    }
}

