/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.electronicpeter.testtimelogger.LoggerAspect;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedWithStringOfClassTxIDLogTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        SynchronizedWithStringOfClassTxIDLogTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SynchronizedWithStringOfClassTxIDLogTest.class);
    }

    @Test
    public void testMethodsaveJustFinishedTxForSameString() {
        SynchronizedWithStringOfClassTxIDLogTest.testMethodsaveJustFinishedTxForSameString_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    @Test
    public void testMethodsaveJustFinishedTxForDifferentString() {
        SynchronizedWithStringOfClassTxIDLogTest.testMethodsaveJustFinishedTxForDifferentString_aroundBody3$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_1);
    }

    private void testMethodsaveJustFinishedTx(int WAIT, boolean differ) {
        try {
            String key1 = "affe";
            String key2 = differ ? "nicht affe" : key1;
            Semaphore semaphore = new Semaphore(2);
            CountDownLatch countDownLatch = new CountDownLatch(2);
            semaphore.acquire(2);
            ARunnable runnable1 = new ARunnable(semaphore, countDownLatch, WAIT, key1);
            ARunnable runnable2 = new ARunnable(semaphore, countDownLatch, WAIT, key2);
            Thread[] instances = new Thread[]{new Thread(runnable1), new Thread(runnable2)};
            instances[0].start();
            instances[1].start();
            LOGGER.info("prepare for start");
            Thread.currentThread();
            Thread.sleep(2000L);
            LOGGER.info("GO");
            semaphore.release(2);
            LOGGER.debug("wait for two instances to finsih");
            countDownLatch.await();
            long fast = Math.min(runnable1.durationInMillis, runnable2.durationInMillis);
            long slow = Math.max(runnable1.durationInMillis, runnable2.durationInMillis);
            LOGGER.info("fast thread took " + fast);
            LOGGER.info("slow thread took " + slow);
            if (differ) {
                Assert.assertTrue((fast < (long)(2 * WAIT) ? 1 : 0) != 0);
                Assert.assertTrue((slow < (long)(2 * WAIT) ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((fast < (long)(2 * WAIT) ? 1 : 0) != 0);
                Assert.assertTrue((slow >= (long)(2 * WAIT) ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blockForTheSameString(String s, int timeToBlock) {
        String string = s;
        synchronized (string) {
            LOGGER.debug("start method for " + s);
            try {
                Thread.currentThread();
                Thread.sleep(timeToBlock);
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
            LOGGER.debug("finish method for " + s);
        }
    }

    private static final /* synthetic */ Object testMethodsaveJustFinishedTxForSameString_aroundBody1$advice(SynchronizedWithStringOfClassTxIDLogTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ajc$this.testMethodsaveJustFinishedTx(100, false);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ Object testMethodsaveJustFinishedTxForDifferentString_aroundBody3$advice(SynchronizedWithStringOfClassTxIDLogTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ajc$this.testMethodsaveJustFinishedTx(100, true);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SynchronizedWithStringOfClassTxIDLogTest.java", SynchronizedWithStringOfClassTxIDLogTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testMethodsaveJustFinishedTxForSameString", "org.adorsys.docusafe.transactional.SynchronizedWithStringOfClassTxIDLogTest", "", "", "", "void"), 22);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testMethodsaveJustFinishedTxForDifferentString", "org.adorsys.docusafe.transactional.SynchronizedWithStringOfClassTxIDLogTest", "", "", "", "void"), 27);
    }

    public static class ARunnable
    implements Runnable {
        private int timeToBlock;
        private String key;
        private Semaphore semaphore;
        private CountDownLatch countDownLatch;
        public long durationInMillis = -1L;

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, int timeToBlock, String key) {
            this.timeToBlock = timeToBlock;
            this.key = key;
            this.semaphore = sem;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                try {
                    this.semaphore.acquire();
                    LOGGER.info("start for key " + this.key);
                    long start = new Date().getTime();
                    SynchronizedWithStringOfClassTxIDLogTest.blockForTheSameString(this.key, this.timeToBlock);
                    this.durationInMillis = new Date().getTime() - start;
                    LOGGER.info("finsih for key " + this.key);
                    this.semaphore.release();
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

