/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.electronicpeter.testtimelogger.LoggerAspect;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelUUIDTest {
    private static final Logger LOGGER;
    private static final int PARALLEL_INSTANCES = 100;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ParallelUUIDTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ParallelUUIDTest.class);
    }

    @Test
    public void createUUIDs() {
        ParallelUUIDTest.createUUIDs_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    private static final /* synthetic */ void createUUIDs_aroundBody0(ParallelUUIDTest ajc$this) {
        try {
            Semaphore semaphore = new Semaphore(100);
            semaphore.acquire(100);
            ARunnable[] runnables = new ARunnable[100];
            Thread[] instances = new Thread[100];
            int i = 0;
            while (i < 100) {
                runnables[i] = new ARunnable(semaphore);
                instances[i] = new Thread(runnables[i]);
                instances[i].start();
                ++i;
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            LOGGER.debug("start 100 threads concurrently now");
            semaphore.release(100);
            Thread.currentThread();
            Thread.sleep(2000L);
            HashSet<UUID> uuids = new HashSet<UUID>();
            int i2 = 0;
            while (i2 < 100) {
                uuids.add(runnables[i2].uuid);
                ++i2;
            }
            Assert.assertEquals((long)100L, (long)uuids.size());
            uuids.add((UUID)uuids.stream().findFirst().get());
            Assert.assertEquals((long)100L, (long)uuids.size());
            LOGGER.debug("finished 100 threads in parallel created 100 different uuids");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static final /* synthetic */ Object createUUIDs_aroundBody1$advice(ParallelUUIDTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ParallelUUIDTest.createUUIDs_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ParallelUUIDTest.java", ParallelUUIDTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUUIDs", "org.adorsys.docusafe.transactional.ParallelUUIDTest", "", "", "", "void"), 22);
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        public UUID uuid;

        public ARunnable(Semaphore semaphore) {
            this.sem = semaphore;
        }

        @Override
        public void run() {
            try {
                this.sem.acquire();
                this.uuid = UUID.randomUUID();
                this.sem.release();
            }
            catch (Exception e) {
                LOGGER.error("Exception " + e);
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

