/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.electronicpeter.testtimelogger.LoggerAspect;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.BucketContentFQNWithUserMetaData;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveFromNonTxToTxTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        MoveFromNonTxToTxTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(MoveFromNonTxToTxTest.class);
    }

    @Test
    public void pseudoMainExplicit() {
        MoveFromNonTxToTxTest.pseudoMainExplicit_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    @Test
    public void pseudoMainImplicit() {
        MoveFromNonTxToTxTest.pseudoMainImplicit_aroundBody3$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_1);
    }

    private DocumentDirectoryFQN init() {
        LOGGER.debug("create System User");
        this.transactionalFileStorage.createUser(this.systemUserIDAuth);
        DocumentDirectoryFQN systemUserBaseDir = new DocumentDirectoryFQN("systemuser");
        LOGGER.debug("create personal User");
        this.transactionalFileStorage.createUser(this.userIDAuth);
        LOGGER.debug("grant system user access to non transactional folder of personal user");
        this.transactionalFileStorage.grantAccessToNonTxFolder(this.userIDAuth, this.systemUserIDAuth.getUserID(), systemUserBaseDir);
        return systemUserBaseDir;
    }

    private DSDocument newDocument(DocumentFQN documentFQN) {
        return new DSDocument(documentFQN, new DocumentContent("some content".getBytes()), new DSDocumentMetaInfo());
    }

    private int checkForNewInFilesImplicit() {
        LOGGER.debug("check for new files in non transactional folder");
        BucketContentFQN list = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        if (list.getFiles().isEmpty()) {
            LOGGER.debug("no new files found");
            return 0;
        }
        LOGGER.debug("new files found");
        LOGGER.debug("start tx");
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        list.getFiles().forEach(documentFQN -> {
            LOGGER.debug("load document " + documentFQN + " from non transactional folder");
            this.transactionalFileStorage.transferFromNonTxToTx(this.userIDAuth, documentFQN, documentFQN);
        });
        BucketContentFQNWithUserMetaData deepListBefore = this.dssi.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        deepListBefore.getFiles().forEach(file -> LOGGER.info(file.getValue()));
        deepListBefore.getFiles().contains(new DocumentFQN("/nonttx/systemuser/file1"));
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        BucketContentFQNWithUserMetaData deepListAfter = this.dssi.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        deepListAfter.getFiles().forEach(file -> LOGGER.info(file.getValue()));
        Assert.assertFalse((boolean)deepListAfter.getFiles().contains(new DocumentFQN("/nonttx/systemuser/file1")));
        return list.getFiles().size();
    }

    private int checkForNewInFilesExplicit() {
        LOGGER.debug("check for new files in non transactional folder");
        BucketContentFQN list = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        if (list.getFiles().isEmpty()) {
            LOGGER.debug("no new files found");
            return 0;
        }
        LOGGER.debug("new files found");
        LOGGER.debug("start tx");
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        list.getFiles().forEach(documentFQN -> {
            LOGGER.debug("load document " + documentFQN + " from non transactional folder");
            DSDocument dsDocument = this.transactionalFileStorage.nonTxReadDocument(this.userIDAuth, documentFQN);
            this.transactionalFileStorage.txStoreDocument(this.userIDAuth, dsDocument);
        });
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        BucketContentFQNWithUserMetaData deepList = this.dssi.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        deepList.getFiles().forEach(file -> LOGGER.info(file.getValue()));
        Assert.assertTrue((boolean)deepList.getFiles().contains(new DocumentFQN("/nonttx/systemuser/file1")));
        list.getFiles().forEach(documentFQN -> this.transactionalFileStorage.nonTxDeleteDocument(this.userIDAuth, documentFQN));
        return list.getFiles().size();
    }

    private static final /* synthetic */ void pseudoMainExplicit_aroundBody0(MoveFromNonTxToTxTest ajc$this) {
        DocumentDirectoryFQN systemUserBaseDir = ajc$this.init();
        Assert.assertEquals((long)0L, (long)ajc$this.checkForNewInFilesExplicit());
        ajc$this.transactionalFileStorage.nonTxStoreDocument(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), ajc$this.newDocument(systemUserBaseDir.addName("file1")));
        Assert.assertEquals((long)1L, (long)ajc$this.checkForNewInFilesExplicit());
        Assert.assertEquals((long)0L, (long)ajc$this.checkForNewInFilesExplicit());
    }

    private static final /* synthetic */ Object pseudoMainExplicit_aroundBody1$advice(MoveFromNonTxToTxTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            MoveFromNonTxToTxTest.pseudoMainExplicit_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void pseudoMainImplicit_aroundBody2(MoveFromNonTxToTxTest ajc$this) {
        DocumentDirectoryFQN systemUserBaseDir = ajc$this.init();
        Assert.assertEquals((long)0L, (long)ajc$this.checkForNewInFilesImplicit());
        ajc$this.transactionalFileStorage.nonTxStoreDocument(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), ajc$this.newDocument(systemUserBaseDir.addName("file1")));
        Assert.assertEquals((long)1L, (long)ajc$this.checkForNewInFilesImplicit());
        Assert.assertEquals((long)0L, (long)ajc$this.checkForNewInFilesImplicit());
    }

    private static final /* synthetic */ Object pseudoMainImplicit_aroundBody3$advice(MoveFromNonTxToTxTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            MoveFromNonTxToTxTest.pseudoMainImplicit_aroundBody2(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MoveFromNonTxToTxTest.java", MoveFromNonTxToTxTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pseudoMainExplicit", "org.adorsys.docusafe.transactional.MoveFromNonTxToTxTest", "", "", "", "void"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pseudoMainImplicit", "org.adorsys.docusafe.transactional.MoveFromNonTxToTxTest", "", "", "", "void"), 48);
    }
}

