/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.electronicpeter.testtimelogger.LoggerAspect;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.exceptions.TxInnerException;
import org.adorsys.docusafe.transactional.exceptions.TxNotActiveException;
import org.adorsys.docusafe.transactional.exceptions.TxRacingConditionException;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalFileStorageTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        TransactionalFileStorageTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TransactionalFileStorageTest.class);
    }

    @Test
    public void testOverwrite() {
        TransactionalFileStorageTest.testOverwrite_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    @Test(expected=TxInnerException.class)
    public void innerTxNotImplementedYet() {
        TransactionalFileStorageTest.innerTxNotImplementedYet_aroundBody3$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_1);
    }

    @Test
    public void testCreateAndChange() {
        TransactionalFileStorageTest.testCreateAndChange_aroundBody5$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_2);
    }

    @Test
    public void testDelete() {
        TransactionalFileStorageTest.testDelete_aroundBody7$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_3);
    }

    @Test(expected=TxNotActiveException.class)
    public void testEndTxTwice() {
        TransactionalFileStorageTest.testEndTxTwice_aroundBody9$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_4);
    }

    @Test
    public void twoCommitsInARow() {
        TransactionalFileStorageTest.twoCommitsInARow_aroundBody11$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_5);
    }

    private static final /* synthetic */ void testOverwrite_aroundBody0(TransactionalFileStorageTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        BucketContentFQN bucketContentFQN = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN.getFiles().get(0));
        DSDocument dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)documentFQN, (Object)dsDocument.getDocumentFQN());
        Assert.assertArrayEquals((byte[])document.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        DSDocument newDocument = null;
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        BucketContentFQN bucketContentFQN2 = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN2.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN2.getFiles().get(0));
        DSDocument dsDocument2 = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        newDocument = new DSDocument(documentFQN, new DocumentContent("new content".getBytes()), dsDocument2.getDsDocumentMetaInfo());
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, newDocument);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])newDocument.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
    }

    private static final /* synthetic */ Object testOverwrite_aroundBody1$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.testOverwrite_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void innerTxNotImplementedYet_aroundBody2(TransactionalFileStorageTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
    }

    private static final /* synthetic */ Object innerTxNotImplementedYet_aroundBody3$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.innerTxNotImplementedYet_aroundBody2(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void testCreateAndChange_aroundBody4(TransactionalFileStorageTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent1 = new DocumentContent("very first".getBytes());
        DocumentContent documentContent2 = new DocumentContent("second".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent1, documentMetaInfo);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("FIRST TXID ");
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document);
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(2);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("SECOND TXID ");
        DSDocument dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        DSDocument document2 = new DSDocument(documentFQN, documentContent2, documentMetaInfo);
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document2);
        ajc$this.requestMemoryContext.switchToUser(3);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("THIRD TXID ");
        ajc$this.requestMemoryContext.switchToUser(2);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(4);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("FOURTH TXID ");
        ajc$this.requestMemoryContext.switchToUser(3);
        dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        ajc$this.requestMemoryContext.switchToUser(4);
        dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent2.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        ajc$this.requestMemoryContext.switchToUser(4);
        BucketContentFQN list = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        list.getDirectories().forEach(dir -> LOGGER.debug("directory : " + dir));
        list.getFiles().forEach(file -> LOGGER.debug("file:" + file));
        Assert.assertEquals((long)1L, (long)list.getFiles().size());
        Assert.assertEquals((long)1L, (long)list.getDirectories().size());
    }

    private static final /* synthetic */ Object testCreateAndChange_aroundBody5$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.testCreateAndChange_aroundBody4(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void testDelete_aroundBody6(TransactionalFileStorageTest ajc$this) {
        DocumentFQN docFQN;
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        int N = 5;
        N = 2;
        int i = 0;
        while (i < N) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            DocumentContent docContent = new DocumentContent(("Content_" + i).getBytes());
            DSDocumentMetaInfo docMetaInfo = new DSDocumentMetaInfo();
            DSDocument doc = new DSDocument(docFQN, docContent, docMetaInfo);
            ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, doc);
            ++i;
        }
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(2);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(3);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(4);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.requestMemoryContext.switchToUser(2);
        i = 0;
        while (i < N) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ajc$this.transactionalFileStorage.txDeleteDocument(ajc$this.userIDAuth, docFQN);
            Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ++i;
        }
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        i = 0;
        while (i < N) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            ajc$this.requestMemoryContext.switchToUser(3);
            Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ajc$this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ++i;
        }
        ajc$this.requestMemoryContext.switchToUser(3);
        ajc$this.transactionalFileStorage.txDeleteFolder(ajc$this.userIDAuth, new DocumentDirectoryFQN("folder1"));
        i = 0;
        while (i < N) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            ajc$this.requestMemoryContext.switchToUser(3);
            Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ajc$this.requestMemoryContext.switchToUser(4);
            Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, docFQN));
            ++i;
        }
        ajc$this.requestMemoryContext.switchToUser(3);
        CatchException.catchException(() -> this.transactionalFileStorage.endTransaction(this.userIDAuth));
        Assert.assertTrue((boolean)(CatchException.caughtException() instanceof TxRacingConditionException));
        ajc$this.requestMemoryContext.switchToUser(4);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
    }

    private static final /* synthetic */ Object testDelete_aroundBody7$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.testDelete_aroundBody6(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void testEndTxTwice_aroundBody8(TransactionalFileStorageTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
    }

    private static final /* synthetic */ Object testEndTxTwice_aroundBody9$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.testEndTxTwice_aroundBody8(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void twoCommitsInARow_aroundBody10(TransactionalFileStorageTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("FIRST TXID ");
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document);
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        LOGGER.debug("SECOND TXID ");
        DSDocument dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        CatchException.catchException(() -> {
            DSDocument dSDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
        });
        Assert.assertTrue((boolean)(CatchException.caughtException() instanceof TxNotActiveException));
    }

    private static final /* synthetic */ Object twoCommitsInARow_aroundBody11$advice(TransactionalFileStorageTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TransactionalFileStorageTest.twoCommitsInARow_aroundBody10(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TransactionalFileStorageTest.java", TransactionalFileStorageTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testOverwrite", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "innerTxNotImplementedYet", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateAndChange", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testDelete", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 150);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testEndTxTwice", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 224);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "twoCommitsInARow", "org.adorsys.docusafe.transactional.TransactionalFileStorageTest", "", "", "", "void"), 234);
    }
}

