/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.electronicpeter.testtimelogger.LoggerAspect;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.impl.WithCache;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.ThreadMemoryContextImpl;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCommitTxTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final int PARALLEL_INSTANCES = 5;
    private static final String FILENAME = "paralleltest.txt";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ParallelCommitTxTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ParallelCommitTxTest.class);
    }

    @Test
    public void parallelCommits() {
        ParallelCommitTxTest.parallelCommits_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    private static final /* synthetic */ void parallelCommits_aroundBody0(ParallelCommitTxTest ajc$this) {
        ThreadMemoryContextImpl requestMemoryContext = new ThreadMemoryContextImpl();
        DocumentSafeServiceImpl dssi = new DocumentSafeServiceImpl(WithCache.FALSE, ExtendedStoreConnectionFactory.get());
        TransactionalDocumentSafeServiceImpl transactionalFileStorage = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestMemoryContext, (DocumentSafeService)dssi);
        try {
            Semaphore semaphore = new Semaphore(5);
            CountDownLatch countDownLatch = new CountDownLatch(5);
            semaphore.acquire(5);
            ARunnable[] runnables = new ARunnable[5];
            Thread[] instances = new Thread[5];
            int i = 0;
            while (i < 5) {
                runnables[i] = new ARunnable(semaphore, countDownLatch, (TransactionalDocumentSafeService)transactionalFileStorage, ajc$this.userIDAuth);
                instances[i] = new Thread(runnables[i]);
                instances[i].start();
                ++i;
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            transactionalFileStorage.createUser(ajc$this.userIDAuth);
            DocumentFQN documentFQN = new DocumentFQN(FILENAME);
            DocumentContent documentContent = new DocumentContent("very first".getBytes());
            DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
            DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
            transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
            LOGGER.debug("FIRST TXID");
            Assert.assertFalse((boolean)transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
            transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document);
            Assert.assertTrue((boolean)transactionalFileStorage.txDocumentExists(ajc$this.userIDAuth, documentFQN));
            transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
            LOGGER.debug("start 5 threads concurrently now");
            semaphore.release(5);
            LOGGER.debug("wait for 5 to finsih");
            countDownLatch.await();
            LOGGER.debug("5 threadas have finished");
            HashSet<Integer> winner = new HashSet<Integer>();
            int i2 = 0;
            while (i2 < 5) {
                winner.add(i2);
                ++i2;
            }
            int errorCounter = 0;
            int i3 = 0;
            while (i3 < 5) {
                if (!runnables[i3].ok) {
                    LOGGER.error("THREAD " + runnables[i3].instanceID + " error " + ++errorCounter + " " + runnables[i3].exception.getMessage());
                    winner.remove(runnables[i3].instanceID);
                }
                ++i3;
            }
            Assert.assertEquals((long)4L, (long)errorCounter);
            Assert.assertEquals((long)1L, (long)winner.size());
            Integer[] winnerInts = new Integer[winner.size()];
            winner.toArray(winnerInts);
            Integer winnerInstanceID = winnerInts[0];
            LOGGER.info("=================================================================================================");
            LOGGER.info("the winner of the 5 instances is thread number " + winnerInstanceID);
            transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
            DSDocument dsDocument = transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, new DocumentFQN(FILENAME));
            LOGGER.info("Content found is " + new String(dsDocument.getDocumentContent().getValue()));
            DocumentContent expectedContent = new DocumentContent(("Thread Number " + winnerInstanceID).getBytes());
            LOGGER.info("expected Content  is " + new String(expectedContent.getValue()));
            Assert.assertEquals((Object)expectedContent, (Object)dsDocument.getDocumentContent());
            transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static final /* synthetic */ Object parallelCommits_aroundBody1$advice(ParallelCommitTxTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            ParallelCommitTxTest.parallelCommits_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ParallelCommitTxTest.java", ParallelCommitTxTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "parallelCommits", "org.adorsys.docusafe.transactional.ParallelCommitTxTest", "", "", "", "void"), 35);
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        private TransactionalDocumentSafeService transactionalFileStorage;
        private UserIDAuth userIDAuth;
        private CountDownLatch countDownLatch;
        public boolean ok = false;
        public Exception exception;

        public ARunnable(Semaphore sem, CountDownLatch countDownLatch, TransactionalDocumentSafeService transactionalFileStorage, UserIDAuth userIDAuth) {
            this.sem = sem;
            this.transactionalFileStorage = transactionalFileStorage;
            this.userIDAuth = userIDAuth;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                try {
                    DocumentFQN documentFQN = new DocumentFQN(ParallelCommitTxTest.FILENAME);
                    DocumentContent documentContent = new DocumentContent(("Thread Number " + this.instanceID).getBytes());
                    DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
                    DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
                    this.sem.acquire();
                    this.transactionalFileStorage.beginTransaction(this.userIDAuth);
                    this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
                    this.transactionalFileStorage.endTransaction(this.userIDAuth);
                    this.sem.release();
                    this.ok = true;
                    LOGGER.info("Thread " + this.instanceID + " successfully wrote file " + ParallelCommitTxTest.FILENAME + " with content \"" + new String(documentContent.getValue()) + "\"");
                }
                catch (Exception e) {
                    this.exception = e;
                    this.countDownLatch.countDown();
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

