/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.TransactionalFileStorageTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyUserCreationTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalFileStorageTest.class);

    public void createUserAfterBegin() {
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
    }
}

