/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.impl.UserMetaDataUtil;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.exceptions.TxAlreadyClosedException;
import org.adorsys.docusafe.transactional.exceptions.TxNotFoundException;
import org.adorsys.docusafe.transactional.impl.LastCommitedTxID;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.transactional.impl.TxIDLog;
import org.adorsys.docusafe.transactional.impl.helper.BucketContentFromHashMapHelper;
import org.adorsys.docusafe.transactional.impl.helper.Class2JsonHelper;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.domain.UserMetaData;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxIDHashMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxIDHashMap.class);
    private static final DocumentFQN filenamebase = new DocumentFQN("TransactionalHashMap.txt");
    private LastCommitedTxID lastCommitedTxID;
    private TxID currentTxID;
    private Date beginTx;
    private Date endTx;
    HashMap<DocumentFQN, TxID> map = new HashMap();

    private TxIDHashMap(LastCommitedTxID lastCommitedTxID, TxID currentTx, Date beginTxDate) {
        this.lastCommitedTxID = lastCommitedTxID;
        this.currentTxID = currentTx;
        this.beginTx = beginTxDate;
        if (this.lastCommitedTxID == null) {
            this.lastCommitedTxID = new LastCommitedTxID("NULL");
        }
    }

    public static TxIDHashMap fromPreviousFileOrNew(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, TxID currentTxID, Date beginTxDate) {
        LastCommitedTxID lastKnownCommitedTxID = TxIDLog.findLastCommitedTxID(documentSafeService, userIDAuth);
        if (lastKnownCommitedTxID == null) {
            return new TxIDHashMap(lastKnownCommitedTxID, currentTxID, beginTxDate);
        }
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastKnownCommitedTxID);
        TxIDHashMap map = TxIDHashMap.readHashMapOfTx(documentSafeService, userIDAuth, lastKnownCommitedTxID);
        map.lastCommitedTxID = new LastCommitedTxID(map.currentTxID.getValue());
        map.currentTxID = currentTxID;
        map.beginTx = beginTxDate;
        map.endTx = null;
        return map;
    }

    public static TxIDHashMap readHashMapOfTx(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, LastCommitedTxID lastCommitedTxID) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastCommitedTxID);
        if (!documentSafeService.documentExists(userIDAuth, file)) {
            throw new TxNotFoundException(file, lastCommitedTxID);
        }
        DSDocument dsDocument = documentSafeService.readDocument(userIDAuth, file);
        return new Class2JsonHelper().txidHashMapFromContent(dsDocument.getDocumentContent());
    }

    public static void deleteHashMapOfTx(DocumentSafeService documentSafeService, UserIDAuth userIDAuth, LastCommitedTxID lastCommitedTxID) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, lastCommitedTxID);
        if (!documentSafeService.documentExists(userIDAuth, file)) {
            throw new TxNotFoundException(file, lastCommitedTxID);
        }
        LOGGER.debug("delete transactional HashMap " + file);
        documentSafeService.deleteDocument(userIDAuth, file);
    }

    public void saveOnce(DocumentSafeService documentSafeService, UserIDAuth userIDAuth) {
        DocumentFQN file = TransactionalDocumentSafeServiceImpl.modifyTxMetaDocumentName(filenamebase, this.currentTxID);
        LOGGER.debug("save " + file.getValue());
        DocumentContent documentContent = new Class2JsonHelper().txidHashMapToContent(this);
        DSDocument dsDocument = new DSDocument(file, documentContent, new DSDocumentMetaInfo());
        if (TxIDLog.dontEncrypt) {
            LOGGER.debug("save " + file.getValue() + " encrypted");
            UserMetaDataUtil.setNoEncryption((UserMetaData)dsDocument.getDsDocumentMetaInfo());
        }
        documentSafeService.storeDocument(userIDAuth, dsDocument);
    }

    public void storeDocument(DocumentFQN documentFQN) {
        this.map.put(documentFQN, this.currentTxID);
    }

    public TxID readDocument(DocumentFQN documentFQN) {
        return this.map.get(documentFQN);
    }

    public void deleteDocument(DocumentFQN documentFQN) {
        this.map.remove(documentFQN);
    }

    public boolean documentExists(DocumentFQN documentFQN) {
        return this.map.containsKey(documentFQN);
    }

    public void deleteFolder(DocumentDirectoryFQN documentDirectoryFQN) {
        ArrayList entriesToRemove = new ArrayList();
        this.map.keySet().forEach(documentFQN -> {
            if (documentFQN.getValue().startsWith(documentDirectoryFQN.getValue())) {
                entriesToRemove.add(documentFQN);
            }
        });
        entriesToRemove.forEach(documentFQN -> this.deleteDocument((DocumentFQN)documentFQN));
    }

    public void setEndTransactionDate(Date endTransactionDate) {
        this.endTx = endTransactionDate;
    }

    public void transactionIsOver(DocumentSafeService documentSafeService, UserIDAuth userIDAuth) {
        TxIDLog.saveJustFinishedTx(documentSafeService, userIDAuth, this.beginTx, this.endTx, this.lastCommitedTxID, this.currentTxID);
    }

    public BucketContentFQN list(DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        return BucketContentFromHashMapHelper.list(this.map.keySet(), documentDirectoryFQN, recursiveFlag);
    }

    public void checkTxStillOpen() {
        if (this.endTx != null) {
            throw new TxAlreadyClosedException(this.currentTxID);
        }
    }
}

