/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.electronicpeter.testtimelogger.LoggerAspect;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HowToUseTransactionalFileStoragePrototypeTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        HowToUseTransactionalFileStoragePrototypeTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(HowToUseTransactionalFileStoragePrototypeTest.class);
    }

    @Test
    public void pseudoMain() {
        HowToUseTransactionalFileStoragePrototypeTest.pseudoMain_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    private DSDocument newDocument(DocumentFQN documentFQN) {
        return new DSDocument(documentFQN, new DocumentContent("some content".getBytes()), new DSDocumentMetaInfo());
    }

    private int checkForNewInFiles() {
        LOGGER.debug("check for new files in non transactional folder");
        BucketContentFQN list = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        if (list.getFiles().isEmpty()) {
            LOGGER.debug("no new files found");
            return 0;
        }
        LOGGER.debug("new files found");
        LOGGER.debug("start tx");
        this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        list.getFiles().forEach(documentFQN -> {
            LOGGER.debug("load document " + documentFQN + " from non transactional folder");
            DSDocument dsDocument = this.transactionalFileStorage.nonTxReadDocument(this.userIDAuth, documentFQN);
            this.transactionalFileStorage.txStoreDocument(this.userIDAuth, dsDocument);
        });
        this.transactionalFileStorage.endTransaction(this.userIDAuth);
        list.getFiles().forEach(documentFQN -> this.transactionalFileStorage.nonTxDeleteDocument(this.userIDAuth, documentFQN));
        return list.getFiles().size();
    }

    private static final /* synthetic */ void pseudoMain_aroundBody0(HowToUseTransactionalFileStoragePrototypeTest ajc$this) {
        LOGGER.debug("create System User");
        ajc$this.transactionalFileStorage.createUser(ajc$this.systemUserIDAuth);
        DocumentDirectoryFQN systemUserBaseDir = new DocumentDirectoryFQN("systemuser");
        LOGGER.debug("create personal User");
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        LOGGER.debug("grant system user access to non transactional folder of personal user");
        ajc$this.transactionalFileStorage.grantAccessToNonTxFolder(ajc$this.userIDAuth, ajc$this.systemUserIDAuth.getUserID(), systemUserBaseDir);
        int filesMoved = ajc$this.checkForNewInFiles();
        Assert.assertEquals((long)0L, (long)filesMoved);
        ajc$this.transactionalFileStorage.nonTxStoreDocument(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), ajc$this.newDocument(systemUserBaseDir.addName("file1")));
        filesMoved = ajc$this.checkForNewInFiles();
        Assert.assertEquals((long)1L, (long)filesMoved);
        filesMoved = ajc$this.checkForNewInFiles();
        Assert.assertEquals((long)0L, (long)filesMoved);
        CatchException.catchException(() -> this.transactionalFileStorage.nonTxStoreDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), this.newDocument(systemUserBaseDir.addDirectory("subdir").addName("file1"))));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }

    private static final /* synthetic */ Object pseudoMain_aroundBody1$advice(HowToUseTransactionalFileStoragePrototypeTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            HowToUseTransactionalFileStoragePrototypeTest.pseudoMain_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HowToUseTransactionalFileStoragePrototypeTest.java", HowToUseTransactionalFileStoragePrototypeTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pseudoMain", "org.adorsys.docusafe.transactional.HowToUseTransactionalFileStoragePrototypeTest", "", "", "", "void"), 34);
    }
}

