/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.electronicpeter.testtimelogger.LoggerAspect;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.apache.commons.lang3.time.StopWatch;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxHistoryCleanupTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TxHistoryCleanupTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TxHistoryCleanupTest.class);
    }

    @Test
    public void createFilesAndDeleteSomeRandomFilesInServeralTransactions() {
        TxHistoryCleanupTest.createFilesAndDeleteSomeRandomFilesInServeralTransactions_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    private int getRandomInRange(int max) {
        int randomNum = ThreadLocalRandom.current().nextInt(0, max);
        return randomNum;
    }

    private static final /* synthetic */ void createFilesAndDeleteSomeRandomFilesInServeralTransactions_aroundBody0(TxHistoryCleanupTest ajc$this) {
        int currentNumberOfFiles;
        BucketContentFQN bucketContentFQN;
        int j;
        StopWatch st = new StopWatch();
        st.start();
        HashMap<DocumentFQN, DocumentContent> memoryMap = new HashMap<DocumentFQN, DocumentContent>();
        int numberOfTransactinos = 3;
        int numberOfFilesToDeletePerTx = 1;
        int numberOfFilesToCreatePerTx = 3;
        int numberOfFilesToOverwritePerTx = 2;
        int expectedNumberOfFilesAfterIteration = numberOfFilesToCreatePerTx * numberOfTransactinos - numberOfTransactinos * numberOfFilesToDeletePerTx;
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        DocumentDirectoryFQN documentDirectoryFQN = new DocumentDirectoryFQN("folder");
        LOGGER.info("numberOfTransactions:                " + numberOfTransactinos);
        LOGGER.info("numberOfFilesToDeletePerTx:          " + numberOfFilesToDeletePerTx);
        LOGGER.info("numberOfFilesToCreatePerTx:          " + numberOfFilesToCreatePerTx);
        LOGGER.info("numberOfFilesToOverwritePerTx:       " + numberOfFilesToOverwritePerTx);
        LOGGER.info("expectedNumberOfFilesAfterIteration: " + expectedNumberOfFilesAfterIteration);
        int staticCounter = 0;
        int i = 0;
        while (i < numberOfTransactinos) {
            ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
            j = 0;
            while (j < numberOfFilesToCreatePerTx) {
                DSDocument document = new DSDocument(documentDirectoryFQN.addName("file_" + staticCounter++ + ".TXT"), new DocumentContent(("Content of File " + i).getBytes()), new DSDocumentMetaInfo());
                ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, document);
                memoryMap.put(document.getDocumentFQN(), document.getDocumentContent());
                ++j;
            }
            ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
            ++i;
        }
        i = 0;
        while (i < numberOfTransactinos) {
            ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
            j = 0;
            while (j < numberOfFilesToDeletePerTx) {
                bucketContentFQN = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToDelete = ajc$this.getRandomInRange(currentNumberOfFiles);
                LOGGER.debug("Transaction number " + i + " has " + currentNumberOfFiles + " files");
                LOGGER.debug("Index to delete is " + indexToDelete);
                ajc$this.transactionalFileStorage.txDeleteDocument(ajc$this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToDelete));
                memoryMap.remove(bucketContentFQN.getFiles().get(indexToDelete));
                ++j;
            }
            ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
            ++i;
        }
        i = 0;
        while (i < numberOfTransactinos) {
            ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
            j = 0;
            while (j < numberOfFilesToOverwritePerTx) {
                bucketContentFQN = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToOverwrite = ajc$this.getRandomInRange(currentNumberOfFiles);
                DSDocument dsDocument = ajc$this.transactionalFileStorage.txReadDocument(ajc$this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToOverwrite));
                DSDocument newDsDocument = new DSDocument(dsDocument.getDocumentFQN(), new DocumentContent((String.valueOf(new String(dsDocument.getDocumentContent().getValue())) + " overwritten in tx ").getBytes()), new DSDocumentMetaInfo());
                ajc$this.transactionalFileStorage.txStoreDocument(ajc$this.userIDAuth, newDsDocument);
                memoryMap.put(newDsDocument.getDocumentFQN(), newDsDocument.getDocumentContent());
                ++j;
            }
            ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
            ++i;
        }
        ajc$this.transactionalFileStorage.beginTransaction(ajc$this.userIDAuth);
        BucketContentFQN bucketContentFQN2 = ajc$this.transactionalFileStorage.txListDocuments(ajc$this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN TRANSACTIONAL LAYER: " + bucketContentFQN2.toString());
        Assert.assertEquals((long)memoryMap.keySet().size(), (long)bucketContentFQN2.getFiles().size());
        bucketContentFQN2.getFiles().forEach(documentFQN -> {
            DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(this.userIDAuth, documentFQN);
            Assert.assertArrayEquals((byte[])((DocumentContent)memoryMap.get(documentFQN)).getValue(), (byte[])dsDocument.getDocumentContent().getValue());
            LOGGER.debug(documentFQN + " checked!");
        });
        ajc$this.transactionalFileStorage.endTransaction(ajc$this.userIDAuth);
        Assert.assertEquals((long)expectedNumberOfFilesAfterIteration, (long)bucketContentFQN2.getFiles().size());
        BucketContentFQN list = ajc$this.dssi.list(ajc$this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN DOCUMENTSAFE: " + list.toString());
        st.stop();
        LOGGER.debug("time for test " + st.toString());
    }

    private static final /* synthetic */ Object createFilesAndDeleteSomeRandomFilesInServeralTransactions_aroundBody1$advice(TxHistoryCleanupTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            TxHistoryCleanupTest.createFilesAndDeleteSomeRandomFilesInServeralTransactions_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TxHistoryCleanupTest.java", TxHistoryCleanupTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createFilesAndDeleteSomeRandomFilesInServeralTransactions", "org.adorsys.docusafe.transactional.TxHistoryCleanupTest", "", "", "", "void"), 28);
    }
}

