/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.electronicpeter.testtimelogger.LoggerAspect;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTransactionalTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        NonTransactionalTest.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(NonTransactionalTest.class);
    }

    @Test
    public void testAllNonTransactional() {
        NonTransactionalTest.testAllNonTransactional_aroundBody1$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_0);
    }

    @Test
    public void testCreateUsersAndSendOneDocument() {
        NonTransactionalTest.testCreateUsersAndSendOneDocument_aroundBody3$advice(this, LoggerAspect.aspectOf(), null, ajc$tjp_1);
    }

    private static final /* synthetic */ void testAllNonTransactional_aroundBody0(NonTransactionalTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.userExists(ajc$this.userIDAuth.getUserID()));
        DocumentFQN documentFQN = new DocumentFQN("file1.txt");
        DSDocument storeDocument = null;
        BucketContentFQN bucketContentFQN = ajc$this.transactionalFileStorage.nonTxListDocuments(ajc$this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.nonTxDocumentExists(ajc$this.userIDAuth, documentFQN));
        DocumentContent documentContent = new DocumentContent("content for in put box".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        storeDocument = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        ajc$this.transactionalFileStorage.nonTxStoreDocument(ajc$this.userIDAuth, storeDocument);
        bucketContentFQN = ajc$this.transactionalFileStorage.nonTxListDocuments(ajc$this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        DSDocument readDocument = ajc$this.transactionalFileStorage.nonTxReadDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])storeDocument.getDocumentContent().getValue(), (byte[])readDocument.getDocumentContent().getValue());
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.nonTxDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.createUser(ajc$this.systemUserIDAuth);
        CatchException.catchException(() -> {
            DSDocument dSDocument = this.transactionalFileStorage.nonTxReadDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN);
        });
        Assert.assertNotNull((Object)CatchException.caughtException());
        CatchException.catchException(() -> {
            boolean bl = this.transactionalFileStorage.nonTxDocumentExists(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN);
        });
        ajc$this.transactionalFileStorage.grantAccessToNonTxFolder(ajc$this.userIDAuth, ajc$this.systemUserIDAuth.getUserID(), documentFQN.getDocumentDirectory());
        DSDocument readDocument2 = ajc$this.transactionalFileStorage.nonTxReadDocument(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), documentFQN);
        Assert.assertArrayEquals((byte[])storeDocument.getDocumentContent().getValue(), (byte[])readDocument2.getDocumentContent().getValue());
        Assert.assertTrue((boolean)ajc$this.transactionalFileStorage.nonTxDocumentExists(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), documentFQN));
        ajc$this.transactionalFileStorage.nonTxDeleteDocument(ajc$this.userIDAuth, documentFQN);
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.nonTxDocumentExists(ajc$this.userIDAuth, documentFQN));
        ajc$this.transactionalFileStorage.destroyUser(ajc$this.userIDAuth);
        Assert.assertFalse((boolean)ajc$this.transactionalFileStorage.userExists(ajc$this.userIDAuth.getUserID()));
    }

    private static final /* synthetic */ Object testAllNonTransactional_aroundBody1$advice(NonTransactionalTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NonTransactionalTest.testAllNonTransactional_aroundBody0(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static final /* synthetic */ void testCreateUsersAndSendOneDocument_aroundBody2(NonTransactionalTest ajc$this) {
        ajc$this.transactionalFileStorage.createUser(ajc$this.userIDAuth);
        ajc$this.transactionalFileStorage.createUser(ajc$this.systemUserIDAuth);
        DocumentDirectoryFQN systemuserBaseDir = new DocumentDirectoryFQN("systemuser");
        ajc$this.transactionalFileStorage.grantAccessToNonTxFolder(ajc$this.userIDAuth, ajc$this.systemUserIDAuth.getUserID(), systemuserBaseDir);
        BucketContentFQN bucketContentFQN = ajc$this.transactionalFileStorage.nonTxListDocuments(ajc$this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        bucketContentFQN.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        bucketContentFQN.getFiles().forEach(dir -> LOGGER.debug("file: " + dir));
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        DocumentFQN documentFQN = systemuserBaseDir.addName("first.txt");
        DocumentContent documentContent = new DocumentContent("content for in put box".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        ajc$this.transactionalFileStorage.nonTxStoreDocument(ajc$this.systemUserIDAuth, ajc$this.userIDAuth.getUserID(), document);
        bucketContentFQN = ajc$this.transactionalFileStorage.nonTxListDocuments(ajc$this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        bucketContentFQN.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        bucketContentFQN.getFiles().forEach(dir -> LOGGER.debug("file: " + dir));
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getDirectories().size());
    }

    private static final /* synthetic */ Object testCreateUsersAndSendOneDocument_aroundBody3$advice(NonTransactionalTest ajc$this, LoggerAspect ajc$aspectInstance, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("start    \"%s\"", thisJoinPointStaticPart.getSignature()));
        long start = System.currentTimeMillis();
        Object result = null;
        RuntimeException throwable = null;
        try {
            AroundClosure aroundClosure = ajc$aroundClosure;
            NonTransactionalTest.testCreateUsersAndSendOneDocument_aroundBody2(ajc$this);
            result = null;
        }
        catch (RuntimeException t) {
            throwable = t;
        }
        long end = System.currentTimeMillis();
        if (throwable != null) {
            LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms finished with exception: %s message: %s", thisJoinPointStaticPart.getSignature(), end - start, throwable.getClass(), throwable.getMessage()));
            throw throwable;
        }
        LoggerAspect.ajc$inlineAccessFieldGet$de_electronicpeter_testtimelogger_LoggerAspect$de_electronicpeter_testtimelogger_LoggerAspect$LOGGER().info(String.format("finished \"%s\" time: %d ms", thisJoinPointStaticPart.getSignature(), end - start));
        return result;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NonTransactionalTest.java", NonTransactionalTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testAllNonTransactional", "org.adorsys.docusafe.transactional.NonTransactionalTest", "", "", "", "void"), 38);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testCreateUsersAndSendOneDocument", "org.adorsys.docusafe.transactional.NonTransactionalTest", "", "", "", "void"), 90);
    }
}

