/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTransactionalTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonTransactionalTest.class);

    @Test
    public void testAllNonTransactional() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        Assert.assertTrue((boolean)this.transactionalFileStorage.userExists(this.userIDAuth.getUserID()));
        DocumentFQN documentFQN = new DocumentFQN("file1.txt");
        DSDocument storeDocument = null;
        BucketContentFQN bucketContentFQN = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        Assert.assertFalse((boolean)this.transactionalFileStorage.nonTxDocumentExists(this.userIDAuth, documentFQN));
        DocumentContent documentContent = new DocumentContent("content for in put box".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        storeDocument = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        this.transactionalFileStorage.nonTxStoreDocument(this.userIDAuth, storeDocument);
        bucketContentFQN = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        DSDocument readDocument = this.transactionalFileStorage.nonTxReadDocument(this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])storeDocument.getDocumentContent().getValue(), (byte[])readDocument.getDocumentContent().getValue());
        Assert.assertTrue((boolean)this.transactionalFileStorage.nonTxDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.createUser(this.systemUserIDAuth);
        CatchException.catchException(() -> this.transactionalFileStorage.nonTxReadDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN));
        Assert.assertNotNull((Object)CatchException.caughtException());
        CatchException.catchException(() -> this.transactionalFileStorage.nonTxDocumentExists(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN));
        this.transactionalFileStorage.grantAccessToNonTxFolder(this.userIDAuth, this.systemUserIDAuth.getUserID(), documentFQN.getDocumentDirectory());
        DSDocument readDocument2 = this.transactionalFileStorage.nonTxReadDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN);
        Assert.assertArrayEquals((byte[])storeDocument.getDocumentContent().getValue(), (byte[])readDocument2.getDocumentContent().getValue());
        Assert.assertTrue((boolean)this.transactionalFileStorage.nonTxDocumentExists(this.systemUserIDAuth, this.userIDAuth.getUserID(), documentFQN));
        this.transactionalFileStorage.nonTxDeleteDocument(this.userIDAuth, documentFQN);
        Assert.assertFalse((boolean)this.transactionalFileStorage.nonTxDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalFileStorage.destroyUser(this.userIDAuth);
        Assert.assertFalse((boolean)this.transactionalFileStorage.userExists(this.userIDAuth.getUserID()));
    }

    @Test
    public void testCreateUsersAndSendOneDocument() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        this.transactionalFileStorage.createUser(this.systemUserIDAuth);
        DocumentDirectoryFQN systemuserBaseDir = new DocumentDirectoryFQN("systemuser");
        this.transactionalFileStorage.grantAccessToNonTxFolder(this.userIDAuth, this.systemUserIDAuth.getUserID(), systemuserBaseDir);
        BucketContentFQN bucketContentFQN = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        bucketContentFQN.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        bucketContentFQN.getFiles().forEach(dir -> LOGGER.debug("file: " + dir));
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)0L, (long)bucketContentFQN.getDirectories().size());
        DocumentFQN documentFQN = systemuserBaseDir.addName("first.txt");
        DocumentContent documentContent = new DocumentContent("content for in put box".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        this.transactionalFileStorage.nonTxStoreDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), document);
        bucketContentFQN = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        bucketContentFQN.getDirectories().forEach(dir -> LOGGER.debug("dir: " + dir));
        bucketContentFQN.getFiles().forEach(dir -> LOGGER.debug("file: " + dir));
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getDirectories().size());
    }
}

