/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl;

import java.util.Date;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.exceptions.TxNotFoundException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionsMap;
import org.adorsys.docusafe.transactional.impl.NonTransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.transactional.impl.TxIDHashMap;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalDocumentSafeServiceImpl
extends NonTransactionalDocumentSafeServiceImpl
implements TransactionalDocumentSafeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceImpl.class);
    static final DocumentDirectoryFQN txMeta = new DocumentDirectoryFQN("meta.tx");
    static final DocumentDirectoryFQN txContent = new DocumentDirectoryFQN("tx");
    public static final String CURRENT_TRANSACTIONS_MAP = "CurrentTransactionsMap";

    public TransactionalDocumentSafeServiceImpl(RequestMemoryContext requestMemoryContext, DocumentSafeService documentSafeService) {
        super(requestMemoryContext, documentSafeService);
        LOGGER.debug("new Instance of TransactionalDocumentSafeServiceImpl");
    }

    @Override
    public TxID beginTransaction(UserIDAuth userIDAuth) {
        Date beginTxDate = new Date();
        TxID currentTxID = new TxID();
        LOGGER.debug("beginTransaction " + currentTxID.getValue());
        TxIDHashMap txIDHashMap = TxIDHashMap.fromPreviousFileOrNew(this.documentSafeService, userIDAuth, currentTxID, beginTxDate);
        CurrentTransactionsMap currentTransactionsMap = (CurrentTransactionsMap)this.requestMemoryContext.get(CURRENT_TRANSACTIONS_MAP);
        if (currentTransactionsMap == null) {
            currentTransactionsMap = new CurrentTransactionsMap();
            this.requestMemoryContext.put(CURRENT_TRANSACTIONS_MAP, currentTransactionsMap);
        }
        currentTransactionsMap.put(currentTxID, txIDHashMap);
        return currentTxID;
    }

    @Override
    public void txStoreDocument(TxID txid, UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("txStoreDocument " + dsDocument.getDocumentFQN().getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        this.documentSafeService.storeDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocument(dsDocument, txid));
        txIDHashMap.storeDocument(dsDocument.getDocumentFQN());
    }

    @Override
    public DSDocument txReadDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txReadDocument " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        TxID txidOfDocument = txIDHashMap.readDocument(documentFQN);
        DSDocument dsDocument = this.documentSafeService.readDocument(userIDAuth, TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(documentFQN, txidOfDocument));
        return new DSDocument(documentFQN, dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    @Override
    public void txDeleteDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDeleteDocument " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.deleteDocument(documentFQN);
    }

    @Override
    public BucketContentFQN txListDocuments(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        return txIDHashMap.list(documentDirectoryFQN, recursiveFlag);
    }

    @Override
    public boolean txDocumentExists(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDocumentExists " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        return txIDHashMap.documentExists(documentFQN);
    }

    @Override
    public void txDeleteFolder(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        LOGGER.debug("txDeleteFolder " + documentDirectoryFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.deleteFolder(documentDirectoryFQN);
    }

    @Override
    public void endTransaction(TxID txid, UserIDAuth userIDAuth) {
        LOGGER.debug("transactionIsOver " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.setEndTransactionDate(new Date());
        txIDHashMap.saveOnce(this.documentSafeService, userIDAuth);
        txIDHashMap.transactionIsOver(this.documentSafeService, userIDAuth);
    }

    public static DSDocument modifyTxDocument(DSDocument dsDocument, TxID txid) {
        return new DSDocument(TransactionalDocumentSafeServiceImpl.modifyTxDocumentName(dsDocument.getDocumentFQN(), txid), dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    public static DocumentFQN modifyTxDocumentName(DocumentFQN origName, TxID txid) {
        return txContent.addName(origName.getValue() + "." + txid.getValue());
    }

    public static DocumentFQN modifyTxMetaDocumentName(DocumentFQN origName, TxID txid) {
        return txMeta.addName(origName.getValue() + "." + txid.getValue());
    }

    private TxIDHashMap getTxIDHashMap(TxID txid) {
        CurrentTransactionsMap currentTransactionsMap = (CurrentTransactionsMap)this.requestMemoryContext.get(CURRENT_TRANSACTIONS_MAP);
        if (currentTransactionsMap == null) {
            throw new TxNotFoundException(txid);
        }
        TxIDHashMap txidHashMap = (TxIDHashMap)currentTransactionsMap.get((Object)txid);
        if (currentTransactionsMap == null) {
            throw new TxNotFoundException(txid);
        }
        txidHashMap.checkTxStillOpen();
        return txidHashMap;
    }
}

