/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl;

import java.util.Date;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.BucketContentFQNImpl;
import org.adorsys.docusafe.business.types.UserID;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.business.types.complex.UserIDAuth;
import org.adorsys.docusafe.service.types.AccessType;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalFileStorage;
import org.adorsys.docusafe.transactional.exceptions.TxNotFoundException;
import org.adorsys.docusafe.transactional.impl.CurrentTransactionsMap;
import org.adorsys.docusafe.transactional.impl.TxIDHashMap;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalFileStorageImpl
implements TransactionalFileStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalFileStorageImpl.class);
    static final DocumentDirectoryFQN txMeta = new DocumentDirectoryFQN("meta.tx");
    static final DocumentDirectoryFQN txContent = new DocumentDirectoryFQN("tx");
    static final DocumentDirectoryFQN nonTxContent = new DocumentDirectoryFQN("nonttx");
    public static final String CURRENT_TRANSACTIONS_MAP = "CurrentTransactionsMap";
    private DocumentSafeService documentSafeService;
    private RequestMemoryContext requestMemoryContext;

    public TransactionalFileStorageImpl(RequestMemoryContext requestMemoryContext, DocumentSafeService documentSafeService) {
        LOGGER.debug("new Instance of TransactionalFileStorageImpl");
        this.documentSafeService = documentSafeService;
        this.requestMemoryContext = requestMemoryContext;
    }

    @Override
    public void createUser(UserIDAuth userIDAuth) {
        this.documentSafeService.createUser(userIDAuth);
    }

    @Override
    public void destroyUser(UserIDAuth userIDAuth) {
        this.documentSafeService.destroyUser(userIDAuth);
    }

    @Override
    public boolean userExists(UserID userID) {
        return this.documentSafeService.userExists(userID);
    }

    @Override
    public void grantAccessToNonTxFolder(UserIDAuth userIDAuth, UserID receiverUserID, DocumentDirectoryFQN documentDirectoryFQN) {
        LOGGER.debug("grant write access from " + userIDAuth.getUserID() + " to " + receiverUserID + " for " + nonTxContent.addDirectory(documentDirectoryFQN));
        this.documentSafeService.grantAccessToUserForFolder(userIDAuth, receiverUserID, nonTxContent.addDirectory(documentDirectoryFQN), AccessType.WRITE);
    }

    @Override
    public void nonTxStoreDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("nonTxStoreDocument " + dsDocument.getDocumentFQN() + " from folder " + nonTxContent + " of user " + userIDAuth.getUserID());
        this.documentSafeService.storeDocument(userIDAuth, this.modifyNonTxDocument(dsDocument));
    }

    @Override
    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("read document " + documentFQN + " from folder " + nonTxContent + " of user " + userIDAuth.getUserID());
        return this.unmodifyNonTxDocument(this.documentSafeService.readDocument(userIDAuth, this.modifyNonTxDocumentName(documentFQN)));
    }

    @Override
    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("nonTxDocumentExists " + documentFQN + " from folder " + nonTxContent + " of user " + userIDAuth.getUserID());
        return this.documentSafeService.documentExists(userIDAuth, this.modifyNonTxDocumentName(documentFQN));
    }

    @Override
    public void nonTxDeleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("delete document " + documentFQN + " from folder " + nonTxContent + " of user " + userIDAuth.getUserID());
        this.documentSafeService.deleteDocument(userIDAuth, this.modifyNonTxDocumentName(documentFQN));
    }

    @Override
    public BucketContentFQN nonTxListDocuments(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        LOGGER.debug("list documents " + documentDirectoryFQN + " from folder " + nonTxContent + " of user " + userIDAuth.getUserID());
        return this.filterNonTxPrefix(this.documentSafeService.list(userIDAuth, this.modifyNonTxDirectoryName(documentDirectoryFQN), recursiveFlag));
    }

    @Override
    public void nonTxStoreDocument(UserIDAuth userIDAuth, UserID documentOwner, DSDocument dsDocument) {
        LOGGER.debug("store document " + dsDocument.getDocumentFQN() + " in folder " + nonTxContent + " of user " + documentOwner + " for user " + userIDAuth.getUserID());
        this.documentSafeService.storeGrantedDocument(userIDAuth, documentOwner, this.modifyNonTxDocument(dsDocument));
    }

    @Override
    public DSDocument nonTxReadDocument(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        LOGGER.debug("read document " + documentFQN + " in folder " + nonTxContent + " of user " + documentOwner + " for user " + userIDAuth.getUserID());
        return this.unmodifyNonTxDocument(this.documentSafeService.readGrantedDocument(userIDAuth, documentOwner, this.modifyNonTxDocumentName(documentFQN)));
    }

    @Override
    public boolean nonTxDocumentExists(UserIDAuth userIDAuth, UserID documentOwner, DocumentFQN documentFQN) {
        LOGGER.debug("document exists " + documentFQN + " in folder " + nonTxContent + " of user " + documentOwner + " for user " + userIDAuth.getUserID());
        return this.documentSafeService.grantedDocumentExists(userIDAuth, documentOwner, this.modifyNonTxDocumentName(documentFQN));
    }

    @Override
    public TxID beginTransaction(UserIDAuth userIDAuth) {
        Date beginTxDate = new Date();
        TxID currentTxID = new TxID();
        LOGGER.debug("beginTransaction " + currentTxID.getValue());
        TxIDHashMap txIDHashMap = TxIDHashMap.fromPreviousFileOrNew(this.documentSafeService, userIDAuth, currentTxID, beginTxDate);
        CurrentTransactionsMap currentTransactionsMap = (CurrentTransactionsMap)this.requestMemoryContext.get(CURRENT_TRANSACTIONS_MAP);
        if (currentTransactionsMap == null) {
            currentTransactionsMap = new CurrentTransactionsMap();
            this.requestMemoryContext.put(CURRENT_TRANSACTIONS_MAP, currentTransactionsMap);
        }
        currentTransactionsMap.put(currentTxID, txIDHashMap);
        return currentTxID;
    }

    @Override
    public void txStoreDocument(TxID txid, UserIDAuth userIDAuth, DSDocument dsDocument) {
        LOGGER.debug("txStoreDocument " + dsDocument.getDocumentFQN().getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        this.documentSafeService.storeDocument(userIDAuth, TransactionalFileStorageImpl.modifyTxDocument(dsDocument, txid));
        txIDHashMap.storeDocument(dsDocument.getDocumentFQN());
    }

    @Override
    public DSDocument txReadDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txReadDocument " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        TxID txidOfDocument = txIDHashMap.readDocument(documentFQN);
        DSDocument dsDocument = this.documentSafeService.readDocument(userIDAuth, TransactionalFileStorageImpl.modifyTxDocumentName(documentFQN, txidOfDocument));
        return new DSDocument(documentFQN, dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    @Override
    public void txDeleteDocument(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDeleteDocument " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.deleteDocument(documentFQN);
    }

    @Override
    public BucketContentFQN txListDocuments(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag recursiveFlag) {
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        return txIDHashMap.list(documentDirectoryFQN, recursiveFlag);
    }

    @Override
    public boolean txDocumentExists(TxID txid, UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        LOGGER.debug("txDocumentExists " + documentFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        return txIDHashMap.documentExists(documentFQN);
    }

    @Override
    public void txDeleteFolder(TxID txid, UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        LOGGER.debug("txDeleteFolder " + documentDirectoryFQN.getValue() + " " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.deleteFolder(documentDirectoryFQN);
    }

    @Override
    public void endTransaction(TxID txid, UserIDAuth userIDAuth) {
        LOGGER.debug("transactionIsOver " + txid.getValue());
        TxIDHashMap txIDHashMap = this.getTxIDHashMap(txid);
        txIDHashMap.setEndTransactionDate(new Date());
        txIDHashMap.saveOnce(this.documentSafeService, userIDAuth);
        txIDHashMap.transactionIsOver(this.documentSafeService, userIDAuth);
    }

    private BucketContentFQN filterNonTxPrefix(BucketContentFQN list) {
        list.getDirectories().forEach(dir -> LOGGER.debug("before filter:" + dir));
        list.getFiles().forEach(file -> LOGGER.debug("before filter:" + file));
        BucketContentFQNImpl filtered = new BucketContentFQNImpl();
        list.getDirectories().forEach(arg_0 -> this.lambda$filterNonTxPrefix$2((BucketContentFQN)filtered, arg_0));
        list.getFiles().forEach(arg_0 -> this.lambda$filterNonTxPrefix$3((BucketContentFQN)filtered, arg_0));
        filtered.getDirectories().forEach(dir -> LOGGER.debug("after filter:" + dir));
        filtered.getFiles().forEach(file -> LOGGER.debug("after filter:" + file));
        return filtered;
    }

    public static DSDocument modifyTxDocument(DSDocument dsDocument, TxID txid) {
        return new DSDocument(TransactionalFileStorageImpl.modifyTxDocumentName(dsDocument.getDocumentFQN(), txid), dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    public static DocumentFQN modifyTxDocumentName(DocumentFQN origName, TxID txid) {
        return txContent.addName(origName.getValue() + "." + txid.getValue());
    }

    public static DocumentFQN modifyTxMetaDocumentName(DocumentFQN origName, TxID txid) {
        return txMeta.addName(origName.getValue() + "." + txid.getValue());
    }

    private DSDocument modifyNonTxDocument(DSDocument dsDocument) {
        return new DSDocument(this.modifyNonTxDocumentName(dsDocument.getDocumentFQN()), dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    private DSDocument unmodifyNonTxDocument(DSDocument dsDocument) {
        return new DSDocument(this.unmodifyNonTxDocumentName(dsDocument.getDocumentFQN()), dsDocument.getDocumentContent(), dsDocument.getDsDocumentMetaInfo());
    }

    private DocumentFQN unmodifyNonTxDocumentName(DocumentFQN origName) {
        if (origName.getValue().startsWith(nonTxContent.getValue())) {
            return new DocumentFQN(origName.getValue().substring(nonTxContent.getValue().length()));
        }
        throw new BaseException("expected " + origName + " to start with " + nonTxContent.getValue());
    }

    private DocumentDirectoryFQN unmodifyNonTxDocumentDirName(DocumentDirectoryFQN origName) {
        if (origName.getValue().startsWith(nonTxContent.getValue())) {
            return new DocumentDirectoryFQN(origName.getValue().substring(nonTxContent.getValue().length()));
        }
        throw new BaseException("expected " + origName + " to start with " + nonTxContent.getValue());
    }

    private DocumentFQN modifyNonTxDocumentName(DocumentFQN origName) {
        return nonTxContent.addName(origName);
    }

    private DocumentDirectoryFQN modifyNonTxDirectoryName(DocumentDirectoryFQN origName) {
        return nonTxContent.addDirectory(origName);
    }

    private TxIDHashMap getTxIDHashMap(TxID txid) {
        CurrentTransactionsMap currentTransactionsMap = (CurrentTransactionsMap)this.requestMemoryContext.get(CURRENT_TRANSACTIONS_MAP);
        if (currentTransactionsMap == null) {
            throw new TxNotFoundException(txid);
        }
        TxIDHashMap txidHashMap = (TxIDHashMap)currentTransactionsMap.get((Object)txid);
        if (currentTransactionsMap == null) {
            throw new TxNotFoundException(txid);
        }
        txidHashMap.checkTxStillOpen();
        return txidHashMap;
    }

    private /* synthetic */ void lambda$filterNonTxPrefix$3(BucketContentFQN filtered, DocumentFQN file) {
        filtered.getFiles().add(this.unmodifyNonTxDocumentName(file));
    }

    private /* synthetic */ void lambda$filterNonTxPrefix$2(BucketContentFQN filtered, DocumentDirectoryFQN dir) {
        filtered.getDirectories().add(this.unmodifyNonTxDocumentDirName(dir));
    }
}

