/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxHistoryCleanupTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxHistoryCleanupTest.class);

    @Test
    public void createFilesAndDeleteSomeRandomFilesInServeralTransactions() {
        int currentNumberOfFiles;
        BucketContentFQN bucketContentFQN;
        int j;
        TxID txid;
        int i;
        StopWatch st = new StopWatch();
        st.start();
        HashMap<DocumentFQN, DocumentContent> memoryMap = new HashMap<DocumentFQN, DocumentContent>();
        int numberOfTransactinos = 9;
        int numberOfFilesToDeletePerTx = 1;
        int numberOfFilesToCreatePerTx = 4;
        int numberOfFilesToOverwritePerTx = 4;
        int expectedNumberOfFilesAfterIteration = numberOfFilesToCreatePerTx * numberOfTransactinos - numberOfTransactinos * numberOfFilesToDeletePerTx;
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentDirectoryFQN documentDirectoryFQN = new DocumentDirectoryFQN("folder");
        int staticCounter = 0;
        for (i = 0; i < numberOfTransactinos; ++i) {
            txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToCreatePerTx; ++j) {
                DSDocument document = new DSDocument(documentDirectoryFQN.addName("file_" + staticCounter++ + ".TXT"), new DocumentContent(("Content of File " + i).getBytes()), new DSDocumentMetaInfo());
                this.transactionalFileStorage.txStoreDocument(txid, this.userIDAuth, document);
                memoryMap.put(document.getDocumentFQN(), document.getDocumentContent());
            }
            this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToDeletePerTx; ++j) {
                bucketContentFQN = this.transactionalFileStorage.txListDocuments(txid, this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToDelete = this.getRandomInRange(currentNumberOfFiles);
                LOGGER.debug("Transaction number " + i + " has " + currentNumberOfFiles + " files");
                LOGGER.debug("Index to delete is " + indexToDelete);
                this.transactionalFileStorage.txDeleteDocument(txid, this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToDelete));
                memoryMap.remove(bucketContentFQN.getFiles().get(indexToDelete));
            }
            this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToOverwritePerTx; ++j) {
                bucketContentFQN = this.transactionalFileStorage.txListDocuments(txid, this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToOverwrite = this.getRandomInRange(currentNumberOfFiles);
                DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(txid, this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToOverwrite));
                DSDocument newDsDocument = new DSDocument(dsDocument.getDocumentFQN(), new DocumentContent((new String(dsDocument.getDocumentContent().getValue()) + " overwritten in tx " + txid.getValue()).getBytes()), new DSDocumentMetaInfo());
                this.transactionalFileStorage.txStoreDocument(txid, this.userIDAuth, newDsDocument);
                memoryMap.put(newDsDocument.getDocumentFQN(), newDsDocument.getDocumentContent());
            }
            this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        }
        TxID txid2 = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        BucketContentFQN bucketContentFQN2 = this.transactionalFileStorage.txListDocuments(txid2, this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN TRANSACTIONAL LAYER: " + bucketContentFQN2.toString());
        Assert.assertEquals((long)memoryMap.keySet().size(), (long)bucketContentFQN2.getFiles().size());
        bucketContentFQN2.getFiles().forEach(documentFQN -> {
            DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(txid2, this.userIDAuth, documentFQN);
            Assert.assertArrayEquals((byte[])((DocumentContent)memoryMap.get(documentFQN)).getValue(), (byte[])dsDocument.getDocumentContent().getValue());
            LOGGER.debug(documentFQN + " checked!");
        });
        this.transactionalFileStorage.endTransaction(txid2, this.userIDAuth);
        Assert.assertEquals((long)expectedNumberOfFilesAfterIteration, (long)bucketContentFQN2.getFiles().size());
        BucketContentFQN list = this.dssi.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN DOCUMENTSAFE: " + list.toString());
        st.stop();
        LOGGER.info("time for test " + st.toString());
    }

    private int getRandomInRange(int max) {
        int randomNum = ThreadLocalRandom.current().nextInt(0, max);
        return randomNum;
    }
}

