/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.exceptions.TxAlreadyClosedException;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalFileStorageTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalFileStorageTest.class);

    @Test
    public void testOverwrite() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent, documentMetaInfo);
        TxID txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.txStoreDocument(txid, this.userIDAuth, document);
        this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        BucketContentFQN bucketContentFQN = this.transactionalFileStorage.txListDocuments(txid, this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN.getFiles().get(0));
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(txid, this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)documentFQN, (Object)dsDocument.getDocumentFQN());
        Assert.assertArrayEquals((byte[])document.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        DSDocument newDocument = null;
        TxID txid2 = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        BucketContentFQN bucketContentFQN2 = this.transactionalFileStorage.txListDocuments(txid2, this.userIDAuth, documentFQN.getDocumentDirectory(), ListRecursiveFlag.TRUE);
        Assert.assertEquals((long)1L, (long)bucketContentFQN2.getFiles().size());
        Assert.assertEquals((Object)documentFQN, bucketContentFQN2.getFiles().get(0));
        DSDocument dsDocument2 = this.transactionalFileStorage.txReadDocument(txid2, this.userIDAuth, documentFQN);
        newDocument = new DSDocument(documentFQN, new DocumentContent("new content".getBytes()), dsDocument2.getDsDocumentMetaInfo());
        this.transactionalFileStorage.txStoreDocument(txid2, this.userIDAuth, newDocument);
        this.transactionalFileStorage.endTransaction(txid2, this.userIDAuth);
        txid2 = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        dsDocument = this.transactionalFileStorage.txReadDocument(txid2, this.userIDAuth, documentFQN);
        Assert.assertArrayEquals((byte[])newDocument.getDocumentContent().getValue(), (byte[])dsDocument.getDocumentContent().getValue());
        this.transactionalFileStorage.endTransaction(txid2, this.userIDAuth);
    }

    @Test
    public void testCreateAndChange() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent1 = new DocumentContent("very first".getBytes());
        DocumentContent documentContent2 = new DocumentContent("second".getBytes());
        DSDocumentMetaInfo documentMetaInfo = new DSDocumentMetaInfo();
        DSDocument document = new DSDocument(documentFQN, documentContent1, documentMetaInfo);
        TxID txid = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("FIRST TXID " + txid);
        Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(txid, this.userIDAuth, documentFQN));
        this.transactionalFileStorage.txStoreDocument(txid, this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(txid, this.userIDAuth, documentFQN));
        this.transactionalFileStorage.endTransaction(txid, this.userIDAuth);
        TxID thirdTx = null;
        TxID fourthTx = null;
        TxID txid2 = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("SECOND TXID " + txid2);
        DSDocument dsDocument = this.transactionalFileStorage.txReadDocument(txid2, this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument.getDocumentContent().getValue()));
        DSDocument document2 = new DSDocument(documentFQN, documentContent2, documentMetaInfo);
        this.transactionalFileStorage.txStoreDocument(txid2, this.userIDAuth, document2);
        thirdTx = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("THIRD TXID " + thirdTx);
        this.transactionalFileStorage.endTransaction(txid2, this.userIDAuth);
        fourthTx = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        LOGGER.debug("FOURTH TXID " + fourthTx);
        DSDocument dsDocument2 = this.transactionalFileStorage.txReadDocument(thirdTx, this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent1.getValue()), (Object)new String(dsDocument2.getDocumentContent().getValue()));
        dsDocument2 = this.transactionalFileStorage.txReadDocument(fourthTx, this.userIDAuth, documentFQN);
        Assert.assertEquals((Object)new String(documentContent2.getValue()), (Object)new String(dsDocument2.getDocumentContent().getValue()));
        BucketContentFQN list = this.transactionalFileStorage.txListDocuments(fourthTx, this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        list.getDirectories().forEach(dir -> LOGGER.debug("directory : " + dir));
        list.getFiles().forEach(file -> LOGGER.debug("file:" + file));
        Assert.assertEquals((long)1L, (long)list.getFiles().size());
        Assert.assertEquals((long)1L, (long)list.getDirectories().size());
    }

    @Test
    public void testDelete() {
        DocumentFQN docFQN;
        int i;
        this.transactionalFileStorage.createUser(this.userIDAuth);
        TxID firstTxID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        int N = 5;
        for (int i2 = 0; i2 < N; ++i2) {
            DocumentFQN docFQN2 = new DocumentFQN("folder1/file_" + i2 + ".txt");
            DocumentContent docContent = new DocumentContent(("Content_" + i2).getBytes());
            DSDocumentMetaInfo docMetaInfo = new DSDocumentMetaInfo();
            DSDocument doc = new DSDocument(docFQN2, docContent, docMetaInfo);
            this.transactionalFileStorage.txStoreDocument(firstTxID, this.userIDAuth, doc);
        }
        this.transactionalFileStorage.endTransaction(firstTxID, this.userIDAuth);
        TxID secondTxID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        TxID thirdTxID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        TxID fourthTxID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(secondTxID, this.userIDAuth, docFQN));
            this.transactionalFileStorage.txDeleteDocument(secondTxID, this.userIDAuth, docFQN);
            Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(secondTxID, this.userIDAuth, docFQN));
        }
        this.transactionalFileStorage.endTransaction(secondTxID, this.userIDAuth);
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(thirdTxID, this.userIDAuth, docFQN));
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(fourthTxID, this.userIDAuth, docFQN));
        }
        this.transactionalFileStorage.txDeleteFolder(thirdTxID, this.userIDAuth, new DocumentDirectoryFQN("folder1"));
        for (i = 0; i < N; ++i) {
            docFQN = new DocumentFQN("folder1/file_" + i + ".txt");
            Assert.assertFalse((boolean)this.transactionalFileStorage.txDocumentExists(thirdTxID, this.userIDAuth, docFQN));
            Assert.assertTrue((boolean)this.transactionalFileStorage.txDocumentExists(fourthTxID, this.userIDAuth, docFQN));
        }
        this.transactionalFileStorage.endTransaction(thirdTxID, this.userIDAuth);
        this.transactionalFileStorage.endTransaction(fourthTxID, this.userIDAuth);
    }

    @Test(expected=TxAlreadyClosedException.class)
    public void testEndTxTwice() {
        this.transactionalFileStorage.createUser(this.userIDAuth);
        TxID firstTxID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        this.transactionalFileStorage.endTransaction(firstTxID, this.userIDAuth);
        this.transactionalFileStorage.endTransaction(firstTxID, this.userIDAuth);
    }
}

