/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import org.adorsys.docusafe.business.types.complex.BucketContentFQN;
import org.adorsys.docusafe.business.types.complex.DSDocument;
import org.adorsys.docusafe.business.types.complex.DSDocumentMetaInfo;
import org.adorsys.docusafe.business.types.complex.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.complex.DocumentFQN;
import org.adorsys.docusafe.service.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionFileStorageBaseTest;
import org.adorsys.docusafe.transactional.types.TxID;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HowToUseTransactionalFileStoragePrototypeTest
extends TransactionFileStorageBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HowToUseTransactionalFileStoragePrototypeTest.class);

    @Test
    public void pseudoMain() {
        LOGGER.info("create System User");
        this.transactionalFileStorage.createUser(this.systemUserIDAuth);
        DocumentDirectoryFQN systemUserBaseDir = new DocumentDirectoryFQN("systemuser");
        LOGGER.info("create personal User");
        this.transactionalFileStorage.createUser(this.userIDAuth);
        LOGGER.info("grant system user access to non transactional folder of personal user");
        this.transactionalFileStorage.grantAccessToNonTxFolder(this.userIDAuth, this.systemUserIDAuth.getUserID(), systemUserBaseDir);
        int filesMoved = this.checkForNewInFiles();
        Assert.assertEquals((long)0L, (long)filesMoved);
        this.transactionalFileStorage.nonTxStoreDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), this.newDocument(systemUserBaseDir.addName("file1")));
        filesMoved = this.checkForNewInFiles();
        Assert.assertEquals((long)1L, (long)filesMoved);
        filesMoved = this.checkForNewInFiles();
        Assert.assertEquals((long)0L, (long)filesMoved);
        CatchException.catchException(() -> this.transactionalFileStorage.nonTxStoreDocument(this.systemUserIDAuth, this.userIDAuth.getUserID(), this.newDocument(systemUserBaseDir.addDirectory("subdir").addName("file1"))));
        Assert.assertNotNull((Object)CatchException.caughtException());
    }

    private DSDocument newDocument(DocumentFQN documentFQN) {
        return new DSDocument(documentFQN, new DocumentContent("some content".getBytes()), new DSDocumentMetaInfo());
    }

    private int checkForNewInFiles() {
        LOGGER.info("check for new files in non transactional folder");
        BucketContentFQN list = this.transactionalFileStorage.nonTxListDocuments(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        if (list.getFiles().isEmpty()) {
            LOGGER.info("no new files found");
            return 0;
        }
        LOGGER.info("new files found");
        LOGGER.info("start tx");
        TxID txID = this.transactionalFileStorage.beginTransaction(this.userIDAuth);
        list.getFiles().forEach(documentFQN -> {
            LOGGER.info("load document " + documentFQN + " from non transactional folder");
            DSDocument dsDocument = this.transactionalFileStorage.nonTxReadDocument(this.userIDAuth, documentFQN);
            this.transactionalFileStorage.txStoreDocument(txID, this.userIDAuth, dsDocument);
        });
        this.transactionalFileStorage.endTransaction(txID, this.userIDAuth);
        list.getFiles().forEach(documentFQN -> this.transactionalFileStorage.nonTxDeleteDocument(this.userIDAuth, documentFQN));
        return list.getFiles().size();
    }
}

