/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.adorsys.docusafe.business.types.BucketContentFQN;
import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import org.adorsys.docusafe.transactional.types.TxBucketContentFQN;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxHistoryCleanupTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxHistoryCleanupTest.class);

    @Test
    public void createFilesAndDeleteSomeRandomFilesInServeralTransactions() {
        int currentNumberOfFiles;
        TxBucketContentFQN bucketContentFQN;
        int j;
        int i;
        StopWatch st = new StopWatch();
        st.start();
        HashMap<DocumentFQN, DocumentContent> memoryMap = new HashMap<DocumentFQN, DocumentContent>();
        int numberOfTransactinos = 3;
        int numberOfFilesToDeletePerTx = 1;
        int numberOfFilesToCreatePerTx = 3;
        int numberOfFilesToOverwritePerTx = 2;
        int expectedNumberOfFilesAfterIteration = numberOfFilesToCreatePerTx * numberOfTransactinos - numberOfTransactinos * numberOfFilesToDeletePerTx;
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentDirectoryFQN documentDirectoryFQN = new DocumentDirectoryFQN("folder");
        LOGGER.info("numberOfTransactions:                " + numberOfTransactinos);
        LOGGER.info("numberOfFilesToDeletePerTx:          " + numberOfFilesToDeletePerTx);
        LOGGER.info("numberOfFilesToCreatePerTx:          " + numberOfFilesToCreatePerTx);
        LOGGER.info("numberOfFilesToOverwritePerTx:       " + numberOfFilesToOverwritePerTx);
        LOGGER.info("expectedNumberOfFilesAfterIteration: " + expectedNumberOfFilesAfterIteration);
        int staticCounter = 0;
        for (i = 0; i < numberOfTransactinos; ++i) {
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToCreatePerTx; ++j) {
                DSDocument document = new DSDocument(documentDirectoryFQN.addName("file_" + staticCounter++ + ".TXT"), new DocumentContent(("Content of File " + i).getBytes()));
                this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
                memoryMap.put(document.getDocumentFQN(), document.getDocumentContent());
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToDeletePerTx; ++j) {
                bucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToDelete = this.getRandomInRange(currentNumberOfFiles);
                LOGGER.debug("Transaction number " + i + " has " + currentNumberOfFiles + " files");
                LOGGER.debug("Index to delete is " + indexToDelete);
                this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToDelete));
                memoryMap.remove(bucketContentFQN.getFiles().get(indexToDelete));
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        for (i = 0; i < numberOfTransactinos; ++i) {
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            for (j = 0; j < numberOfFilesToOverwritePerTx; ++j) {
                bucketContentFQN = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
                currentNumberOfFiles = bucketContentFQN.getFiles().size();
                int indexToOverwrite = this.getRandomInRange(currentNumberOfFiles);
                DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, (DocumentFQN)bucketContentFQN.getFiles().get(indexToOverwrite));
                DSDocument newDsDocument = new DSDocument(dsDocument.getDocumentFQN(), new DocumentContent((new String(dsDocument.getDocumentContent().getValue()) + " overwritten in tx ").getBytes()));
                this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, newDsDocument);
                memoryMap.put(newDsDocument.getDocumentFQN(), newDsDocument.getDocumentContent());
            }
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        TxBucketContentFQN bucketContentFQN2 = this.transactionalDocumentSafeService.txListDocuments(this.userIDAuth, documentDirectoryFQN, ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN TRANSACTIONAL LAYER: " + bucketContentFQN2.toString());
        Assert.assertEquals((long)memoryMap.keySet().size(), (long)bucketContentFQN2.getFiles().size());
        bucketContentFQN2.getFiles().forEach(documentFQN -> {
            DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, documentFQN);
            Assert.assertArrayEquals((byte[])((DocumentContent)memoryMap.get(documentFQN)).getValue(), (byte[])dsDocument.getDocumentContent().getValue());
            LOGGER.debug(documentFQN + " checked!");
        });
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        Assert.assertEquals((long)expectedNumberOfFilesAfterIteration, (long)bucketContentFQN2.getFiles().size());
        List list = this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        LOGGER.debug("LIST OF FILES IN DOCUMENTSAFE: " + list.toString());
        st.stop();
        LOGGER.debug("time for test " + st.toString());
    }

    private void show(String description, BucketContentFQN bucketContentFQN) {
        LOGGER.info("--------------------------------- begin " + description);
        LOGGER.info("files" + bucketContentFQN.getFiles().size());
        bucketContentFQN.getFiles().forEach(dir -> LOGGER.info(dir.toString()));
        LOGGER.info("--------------------------------- end " + description);
    }

    private int getRandomInRange(int max) {
        LOGGER.debug("Also max ist " + max);
        return ThreadLocalRandom.current().nextInt(0, max);
    }
}

