/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.service.api.keystore.types.ReadKeyPassword;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.service.api.types.UserID;
import org.adorsys.docusafe.service.api.types.UserIDAuth;
import org.adorsys.docusafe.transactional.NonTransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.SimpleRequestMemoryContextImpl;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceBaseTest.class);
    protected SimpleRequestMemoryContextImpl requestMemoryContext = new SimpleRequestMemoryContextImpl();
    protected DocumentSafeService dss = new DocumentSafeServiceImpl(DFSConnectionFactory.get());
    protected TransactionalDocumentSafeService transactionalDocumentSafeService = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)this.requestMemoryContext, this.dss);
    protected NonTransactionalDocumentSafeService nonTransactionalDocumentSafeService = this.transactionalDocumentSafeService;
    protected UserIDAuth userIDAuth = new UserIDAuth(new UserID("peter"), new ReadKeyPassword("password"));
    protected UserIDAuth systemUserIDAuth = new UserIDAuth(new UserID("system"), new ReadKeyPassword("systemPassword"));

    @Before
    public void preTestBase() {
        LOGGER.debug("preTestBase");
        DFSConnectionFactory.get().deleteDatabase();
        LOGGER.debug("TransactionalDcoumentSafeService is " + this.transactionalDocumentSafeService.getClass().getName());
    }

    @After
    public void afterTestBase() {
        LOGGER.debug("afterTestBase");
        CatchException.catchException(() -> this.transactionalDocumentSafeService.destroyUser(this.userIDAuth));
        CatchException.catchException(() -> this.transactionalDocumentSafeService.destroyUser(this.systemUserIDAuth));
    }

    protected DSDocument createDocument(String name) {
        DocumentFQN documentFQN = new DocumentFQN(name);
        DocumentContent documentContent = new DocumentContent(("CONTENT OF FILE " + name).getBytes());
        return new DSDocument(documentFQN, documentContent);
    }
}

