/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import de.adorsys.common.exceptions.BaseExceptionHandler;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelUUIDTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelUUIDTest.class);
    private static final int PARALLEL_INSTANCES = 100;

    @Test
    public void createUUIDs() {
        try {
            Semaphore semaphore = new Semaphore(100);
            semaphore.acquire(100);
            ARunnable[] runnables = new ARunnable[100];
            Thread[] instances = new Thread[100];
            for (int i = 0; i < 100; ++i) {
                runnables[i] = new ARunnable(semaphore);
                instances[i] = new Thread(runnables[i]);
                instances[i].start();
            }
            Thread.currentThread();
            Thread.sleep(2000L);
            LOGGER.debug("start 100 threads concurrently now");
            semaphore.release(100);
            Thread.currentThread();
            Thread.sleep(2000L);
            HashSet<UUID> uuids = new HashSet<UUID>();
            for (int i = 0; i < 100; ++i) {
                uuids.add(runnables[i].uuid);
            }
            Assert.assertEquals((long)100L, (long)uuids.size());
            uuids.add((UUID)uuids.stream().findFirst().get());
            Assert.assertEquals((long)100L, (long)uuids.size());
            LOGGER.debug("finished 100 threads in parallel created 100 different uuids");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class ARunnable
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ARunnable.class);
        private static int instanceCounter = 0;
        private int instanceID = instanceCounter++;
        private Semaphore sem;
        public UUID uuid;

        public ARunnable(Semaphore semaphore) {
            this.sem = semaphore;
        }

        @Override
        public void run() {
            try {
                this.sem.acquire();
                this.uuid = UUID.randomUUID();
                this.sem.release();
            }
            catch (Exception e) {
                LOGGER.error("Exception " + e);
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

