/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import com.googlecode.catchexception.CatchException;
import de.adorsys.dfs.connection.api.types.ListRecursiveFlag;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import java.util.List;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DocumentDirectoryFQN;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.SimpleRequestMemoryContextImpl;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTxHistoryCleanupTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(ParallelTxHistoryCleanupTest.class);
    private static final int MAX_COMMITED_TX_FOR_CLEANUP = 5;
    private SimpleRequestMemoryContextImpl secondRequestMemoryContext = new SimpleRequestMemoryContextImpl();
    private TransactionalDocumentSafeService secondTransactionalDocumentSafeService = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)this.secondRequestMemoryContext, (DocumentSafeService)new DocumentSafeServiceImpl(DFSConnectionFactory.get()));

    @Test
    public void cleanUpWithParallelTransactionsTest() {
        StopWatch st = new StopWatch();
        st.start();
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        for (int i = 0; i <= 5; ++i) {
            this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
            this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, this.createDocument("" + i));
            this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        }
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        DSDocument dsDocument = this.transactionalDocumentSafeService.txReadDocument(this.userIDAuth, new DocumentFQN("0"));
        DSDocument dsDocumentChanged = new DSDocument(dsDocument.getDocumentFQN(), new DocumentContent((new String(dsDocument.getDocumentContent().getValue()) + " updated").getBytes()));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, dsDocumentChanged);
        this.transactionalDocumentSafeService.txDeleteDocument(this.userIDAuth, new DocumentFQN("1"));
        this.secondTransactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.secondTransactionalDocumentSafeService.txStoreDocument(this.userIDAuth, this.createDocument("1"));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
        CatchException.catchException(() -> this.secondTransactionalDocumentSafeService.endTransaction(this.userIDAuth));
        Assert.assertNotNull((Object)CatchException.caughtException());
        List list = this.dss.list(this.userIDAuth, new DocumentDirectoryFQN("/"), ListRecursiveFlag.TRUE);
        log.debug("LIST OF FILES IN DOCUMENTSAFE: " + list.toString());
        st.stop();
        log.debug("time for test " + st.toString());
    }
}

