/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional;

import org.adorsys.docusafe.business.types.DSDocument;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceBaseTest;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeServiceTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyUserCreationTest
extends TransactionalDocumentSafeServiceBaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalDocumentSafeServiceTest.class);

    public void createUserAfterBegin() {
        this.transactionalDocumentSafeService.beginTransaction(this.userIDAuth);
        this.transactionalDocumentSafeService.createUser(this.userIDAuth);
        DocumentFQN documentFQN = new DocumentFQN("testxTFolder/first.txt");
        DocumentContent documentContent = new DocumentContent("very first".getBytes());
        DSDocument document = new DSDocument(documentFQN, documentContent);
        Assert.assertFalse((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.txStoreDocument(this.userIDAuth, document);
        Assert.assertTrue((boolean)this.transactionalDocumentSafeService.txDocumentExists(this.userIDAuth, documentFQN));
        this.transactionalDocumentSafeService.endTransaction(this.userIDAuth);
    }
}

