/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.transactional.impl.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.adorsys.common.exceptions.BaseExceptionHandler;
import java.lang.reflect.Type;
import org.adorsys.docusafe.business.types.DocumentFQN;
import org.adorsys.docusafe.service.api.types.DocumentContent;
import org.adorsys.docusafe.transactional.impl.LastCommitedTxID;
import org.adorsys.docusafe.transactional.impl.TxIDHashMapWrapper;
import org.adorsys.docusafe.transactional.impl.TxIDLog;
import org.adorsys.docusafe.transactional.impl.helper.DocumentFQNJsonAdapter;
import org.adorsys.docusafe.transactional.impl.helper.LastCommitedTxIDJsonAdapter;
import org.adorsys.docusafe.transactional.impl.helper.TxIDJsonAdapter;
import org.adorsys.docusafe.transactional.types.TxID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Class2JsonHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Class2JsonHelper.class);
    private static final String CHARSET = "UTF-8";
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";
    private Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(TxID.class, (Object)new TxIDJsonAdapter()).registerTypeAdapter(LastCommitedTxID.class, (Object)new LastCommitedTxIDJsonAdapter()).registerTypeAdapter(DocumentFQN.class, (Object)new DocumentFQNJsonAdapter()).setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").create();

    public TxIDHashMapWrapper txidHashMapFromContent(DocumentContent documentContent) {
        try {
            String jsonString = new String(documentContent.getValue(), CHARSET);
            LOGGER.trace("content to hashmap:" + jsonString);
            return (TxIDHashMapWrapper)this.gson.fromJson(jsonString, TxIDHashMapWrapper.class);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public DocumentContent txidHashMapToContent(TxIDHashMapWrapper txIDHashMapWrapper) {
        try {
            String s = this.gson.toJson((Object)txIDHashMapWrapper);
            LOGGER.trace("hashmap to content:" + s);
            return new DocumentContent(s.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public TxIDLog txidLogFromContent(DocumentContent documentContent) {
        try {
            String jsonString = new String(documentContent.getValue(), CHARSET);
            LOGGER.trace("content to txidlog:" + jsonString);
            return (TxIDLog)this.gson.fromJson(jsonString, TxIDLog.class);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public DocumentContent txidLogToContent(TxIDLog txidLog) {
        try {
            String s = this.gson.toJson((Object)txidLog);
            LOGGER.trace("txidlog to content:" + s);
            return new DocumentContent(s.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private static class InterfaceAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private static final String CLASSNAME = "CLASSNAME";
        private static final String DATA = "DATA";

        private InterfaceAdapter() {
        }

        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)jsonObject.get(CLASSNAME);
            String className = prim.getAsString();
            Class klass = this.getObjectClass(className);
            return (T)jsonDeserializationContext.deserialize(jsonObject.get(DATA), (Type)klass);
        }

        public JsonElement serialize(T jsonElement, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(CLASSNAME, jsonElement.getClass().getName());
            jsonObject.add(DATA, jsonSerializationContext.serialize(jsonElement));
            return jsonObject;
        }

        public Class getObjectClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException(e.getMessage());
            }
        }
    }
}

