/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.docusafe.spring.factory;

import de.adorsys.common.exceptions.BaseException;
import de.adorsys.dfs.connection.api.filesystem.FilesystemConnectionPropertiesImpl;
import de.adorsys.dfs.connection.api.service.api.DFSConnection;
import de.adorsys.dfs.connection.api.types.connection.AmazonS3RootBucketName;
import de.adorsys.dfs.connection.api.types.connection.FilesystemRootBucketName;
import de.adorsys.dfs.connection.api.types.properties.AmazonS3ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.ConnectionProperties;
import de.adorsys.dfs.connection.api.types.properties.FilesystemConnectionProperties;
import de.adorsys.dfs.connection.impl.amazons3.AmazonS3ConnectionProperitesImpl;
import de.adorsys.dfs.connection.impl.factory.DFSConnectionFactory;
import de.adorsys.docusafe.spring.config.SpringDFSConnectionProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringDFSConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDFSConnectionFactory.class);
    private SpringDFSConnectionProperties wiredProperties;
    private static int instanceCounter = 0;
    private final int instanceId;
    private Map<String, DFSConnection> map = new HashMap<String, DFSConnection>();

    public SpringDFSConnectionFactory(SpringDFSConnectionProperties wiredProperties) {
        this.wiredProperties = wiredProperties;
        this.instanceId = ++instanceCounter;
        if (this.instanceId > 1) {
            LOGGER.warn("Expected just to exist exactly one Factory. But this is Instance No: " + this.instanceId);
        }
    }

    public DFSConnection getDFSConnectionWithSubDir(String basedir) {
        if (this.map.containsKey(basedir)) {
            LOGGER.info("Connection for " + (basedir == null ? "default" : basedir) + " is known. Singleton is returned");
            return this.map.get(basedir);
        }
        if (this.wiredProperties.getFilesystem() != null) {
            FilesystemConnectionPropertiesImpl properties = new FilesystemConnectionPropertiesImpl((FilesystemConnectionProperties)this.wiredProperties.getFilesystem());
            if (basedir != null) {
                String origName = properties.getFilesystemRootBucketName().getValue();
                String newName = origName + "." + basedir;
                properties.setFilesystemRootBucketName(new FilesystemRootBucketName(newName));
            }
            LOGGER.debug("jetzt filesystem");
            this.map.put(basedir, DFSConnectionFactory.get((ConnectionProperties)properties));
        } else if (this.wiredProperties.getAmazons3() != null) {
            AmazonS3ConnectionProperitesImpl properties = new AmazonS3ConnectionProperitesImpl((AmazonS3ConnectionProperties)this.wiredProperties.getAmazons3());
            if (basedir != null) {
                String origName = properties.getAmazonS3RootBucketName().getValue();
                String newName = origName + "." + basedir;
                properties.setAmazonS3RootBucketName(new AmazonS3RootBucketName(newName));
            }
            LOGGER.debug("jetzt amazon");
            this.map.put(basedir, DFSConnectionFactory.get((ConnectionProperties)properties));
        } else {
            String emessage = "at least filesystem, amazons3, minio or mongo has to be specified with ";
            String message = emessage + "\ndocusafe:\n  storeconnection:\n    filesystem:\n      rootbucket: (mandatory)\n" + "\ndocusafe:\n  storeconnection:\n    amazons3:\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      region: (optional)\n      rootbucket: (optional)\n";
            LOGGER.error(message);
            throw new BaseException(emessage);
        }
        return this.map.get(basedir);
    }
}

