/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.config;

import org.adorsys.docusafe.spring.config.SpringConnectionPropertiesImpl;
import org.adorsys.encobject.types.connection.MongoDatabaseName;
import org.adorsys.encobject.types.connection.MongoHost;
import org.adorsys.encobject.types.connection.MongoPassword;
import org.adorsys.encobject.types.connection.MongoPort;
import org.adorsys.encobject.types.connection.MongoUser;
import org.adorsys.encobject.types.properties.MongoConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="docusafe.storeconnection.mongo")
@Validated
public class SpringMongoConnectionProperties
extends SpringConnectionPropertiesImpl
implements MongoConnectionProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMongoConnectionProperties.class);
    public static final String template = "\ndocusafe:\n  storeconnection:\n    mongo:\n      database: (mandatory)\n      host: (mandatory)\n      port: (mandatory)\n      user: (optional)\n      password: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n      encryptionfilenameonly (optional. TRUE means, path is not encrypted)";
    private String database;
    private String host;
    private String port;
    @Nullable
    private String user = null;
    @Nullable
    private String password = null;

    public MongoDatabaseName getMongoDatabaseName() {
        return new MongoDatabaseName(this.database);
    }

    public MongoHost getMongoHost() {
        return new MongoHost(this.host);
    }

    public MongoPort getMongoPort() {
        return new MongoPort(Long.valueOf(Long.parseLong(this.port)));
    }

    public MongoUser getMongoUser() {
        if (this.user == null || this.user.length() == 0 || this.user.equalsIgnoreCase("null")) {
            return null;
        }
        return new MongoUser(this.user);
    }

    public MongoPassword getMongoPassword() {
        if (this.password == null || this.password.length() == 0 || this.password.equalsIgnoreCase("null")) {
            return null;
        }
        return new MongoPassword(this.password);
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

