/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.factory;

import java.util.HashMap;
import java.util.Map;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3ConnectionProperitesImpl;
import org.adorsys.cryptoutils.mongodbstoreconnection.MongoConnectionPropertiesImpl;
import org.adorsys.cryptoutils.storeconnectionfactory.ExtendedStoreConnectionFactory;
import org.adorsys.docusafe.spring.config.SpringDocusafeStoreconnectionProperties;
import org.adorsys.docusafe.spring.factory.MongoURIChanger;
import org.adorsys.encobject.filesystem.FilesystemConnectionPropertiesImpl;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.types.connection.AmazonS3RootBucketName;
import org.adorsys.encobject.types.connection.FilesystemRootBucketName;
import org.adorsys.encobject.types.properties.AmazonS3ConnectionProperties;
import org.adorsys.encobject.types.properties.ConnectionProperties;
import org.adorsys.encobject.types.properties.FilesystemConnectionProperties;
import org.adorsys.encobject.types.properties.MongoConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringExtendedStoreConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringExtendedStoreConnectionFactory.class);
    private SpringDocusafeStoreconnectionProperties wiredProperties;
    private static int instanceCounter = 0;
    private final int instanceId;
    private Map<String, ExtendedStoreConnection> map = new HashMap<String, ExtendedStoreConnection>();

    public SpringExtendedStoreConnectionFactory(SpringDocusafeStoreconnectionProperties wiredProperties) {
        this.wiredProperties = wiredProperties;
        this.instanceId = ++instanceCounter;
        if (this.instanceId > 1) {
            LOGGER.warn("Expected just to exist exactly one Factory. But this is Instance No: " + this.instanceId);
        }
    }

    public ExtendedStoreConnection getExtendedStoreConnectionWithSubDir(String basedir) {
        if (this.map.containsKey(basedir)) {
            LOGGER.info("Connection for " + (basedir == null ? "default" : basedir) + " is known. Singleton is returned");
            return this.map.get(basedir);
        }
        if (this.wiredProperties.getFilesystem() != null) {
            FilesystemConnectionPropertiesImpl properties = new FilesystemConnectionPropertiesImpl((FilesystemConnectionProperties)this.wiredProperties.getFilesystem());
            if (basedir != null) {
                String origName = properties.getFilesystemRootBucketName().getValue();
                String newName = origName + basedir;
                properties.setFilesystemRootBucketName(new FilesystemRootBucketName(newName));
            }
            LOGGER.debug("jetzt filesystem");
            this.map.put(basedir, ExtendedStoreConnectionFactory.get((ConnectionProperties)properties));
        } else if (this.wiredProperties.getAmazons3() != null) {
            AmazonS3ConnectionProperitesImpl properties = new AmazonS3ConnectionProperitesImpl((AmazonS3ConnectionProperties)this.wiredProperties.getAmazons3());
            if (basedir != null) {
                String origName = properties.getAmazonS3RootBucketName().getValue();
                String newName = origName + basedir;
                properties.setAmazonS3RootBucketName(new AmazonS3RootBucketName(newName));
            }
            LOGGER.debug("jetzt amazon");
            this.map.put(basedir, ExtendedStoreConnectionFactory.get((ConnectionProperties)properties));
        } else if (this.wiredProperties.getMongo() != null) {
            MongoConnectionPropertiesImpl properties = new MongoConnectionPropertiesImpl((MongoConnectionProperties)this.wiredProperties.getMongo());
            if (basedir != null) {
                properties.setMongoURI(new MongoURIChanger(properties.getMongoURI()).modifyRootBucket(basedir));
            }
            LOGGER.debug("jetzt mongo");
            this.map.put(basedir, ExtendedStoreConnectionFactory.get((ConnectionProperties)properties));
        } else {
            String emessage = "at least filesystem, amazons3, minio or mongo has to be specified with ";
            String message = emessage + "\ndocusafe:\n  storeconnection:\n    filesystem:\n      rootbucket: (mandatory)\n      encryptionpassword: (optional. null means no ecryption)\n      encryptionfilenameonly: (optional. TRUE means, path is not encrypted)" + "\ndocusafe:\n  storeconnection:\n    amazons3:\n      url: (mandatory)\n      accesskey: (mandatory)\n      secretkey: (mandatory)\n      region: (optional)\n      rootbucket: (optional)\n      encryptionpassword: (optional. null means no ecryption)\n      encryptionfilenameonly: (optional. TRUE means, path is not encrypted)" + "\ndocusafe:\n  storeconnection:\n    mongo:\n      mongoURI: (mandatory)\n                (<mongoClientUri> (mongodb://[username:password@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[database.collection][?options]]) - see http://mongodb.github.io/mongo-java-driver/3.6/javadoc/com/mongodb/MongoClientURI.html)\n      encryptionpassword: (optional. null means no ecryption)\n      encryptionfilenameonly: (optional. TRUE means, path is not encrypted)";
            LOGGER.error(message);
            throw new BaseException(emessage);
        }
        return this.map.get(basedir);
    }
}

