/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.docusafe.spring.factory;

import java.util.HashMap;
import java.util.Map;
import org.adorsys.docusafe.business.DocumentSafeService;
import org.adorsys.docusafe.business.impl.DocumentSafeServiceImpl;
import org.adorsys.docusafe.cached.transactional.CachedTransactionalDocumentSafeService;
import org.adorsys.docusafe.cached.transactional.impl.CachedTransactionalDocumentSafeServiceImpl;
import org.adorsys.docusafe.spring.SimpleRequestMemoryContextImpl;
import org.adorsys.docusafe.spring.factory.SpringExtendedStoreConnectionFactory;
import org.adorsys.docusafe.transactional.RequestMemoryContext;
import org.adorsys.docusafe.transactional.TransactionalDocumentSafeService;
import org.adorsys.docusafe.transactional.impl.TransactionalDocumentSafeServiceImpl;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCachedTransactionalDocusafeServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCachedTransactionalDocusafeServiceFactory.class);
    private SpringExtendedStoreConnectionFactory connectionFactory;
    private static int instanceCounter = 0;
    private final int instanceId;
    private Map<String, CachedTransactionalDocumentSafeService> map = new HashMap<String, CachedTransactionalDocumentSafeService>();

    public SpringCachedTransactionalDocusafeServiceFactory(SpringExtendedStoreConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.instanceId = ++instanceCounter;
        if (this.instanceId > 1) {
            LOGGER.warn("Expected just to exist exactly one Factory. But this is Instance No: " + this.instanceId);
        }
    }

    public CachedTransactionalDocumentSafeService getCachedTransactionalDocumentSafeServiceWithSubdir(String basedir) {
        if (this.map.containsKey(basedir)) {
            LOGGER.info("Connection for " + (basedir == null ? "default" : basedir) + " is known. Singleton is returned");
            return this.map.get(basedir);
        }
        LOGGER.info("getExtendedStoreConnection");
        ExtendedStoreConnection extendedStoreConnection = this.connectionFactory.getExtendedStoreConnectionWithSubDir(basedir);
        LOGGER.info(CachedTransactionalDocumentSafeService.class.getName() + " is required as @Bean");
        LOGGER.debug("create documentSafeService");
        DocumentSafeServiceImpl documentSafeService = new DocumentSafeServiceImpl(extendedStoreConnection);
        SimpleRequestMemoryContextImpl requestContext = new SimpleRequestMemoryContextImpl();
        LOGGER.debug("create transactionalDocumentSafeService");
        TransactionalDocumentSafeServiceImpl transactionalDocumentSafeService = new TransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestContext, (DocumentSafeService)documentSafeService);
        LOGGER.debug("create cachedTransactionalDocumentSafeService");
        CachedTransactionalDocumentSafeServiceImpl cachedTransactionalDocumentSafeService = new CachedTransactionalDocumentSafeServiceImpl((RequestMemoryContext)requestContext, (TransactionalDocumentSafeService)transactionalDocumentSafeService, (DocumentSafeService)documentSafeService);
        this.map.put(basedir, (CachedTransactionalDocumentSafeService)cachedTransactionalDocumentSafeService);
        return cachedTransactionalDocumentSafeService;
    }
}

